/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.data.CellRenderData;
import com.deepoove.poi.data.MiniTableRenderData;
import com.deepoove.poi.data.RowRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.TableStyle;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.util.StyleUtils;
import com.deepoove.poi.util.TableTools;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.BodyContainerFactory;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

public class MiniTableRenderPolicy
extends AbstractRenderPolicy<MiniTableRenderData> {
    @Override
    protected boolean validate(MiniTableRenderData data) {
        return null != data && (data.isSetBody() || data.isSetHeader());
    }

    @Override
    public void doRender(RenderContext<MiniTableRenderData> context) throws Exception {
        Helper.renderMiniTable(context.getRun(), context.getData());
    }

    @Override
    protected void afterRender(RenderContext<MiniTableRenderData> context) {
        MiniTableRenderPolicy.clearPlaceholder(context, true);
    }

    public static class Helper {
        public static void renderMiniTable(XWPFRun run, MiniTableRenderData data) {
            if (data.isSetBody()) {
                Helper.renderTable(run, data);
            } else {
                Helper.renderNoDataTable(run, data);
            }
        }

        public static void renderTable(XWPFRun run, MiniTableRenderData tableData) {
            int row = tableData.getRows().size();
            int col = 0;
            if (!tableData.isSetHeader()) {
                col = Helper.getMaxColumFromData(tableData.getRows());
            } else {
                ++row;
                col = tableData.getHeader().size();
            }
            BodyContainer bodyContainer = BodyContainerFactory.getBodyContainer(run);
            XWPFTable table = bodyContainer.insertNewTable(run, row, col);
            TableTools.initBasicTable(table, col, tableData.getWidth(), tableData.getStyle());
            int startRow = 0;
            if (tableData.isSetHeader()) {
                Helper.renderRow(table, startRow++, tableData.getHeader());
            }
            for (RowRenderData data : tableData.getRows()) {
                Helper.renderRow(table, startRow++, data);
            }
        }

        public static void renderNoDataTable(XWPFRun run, MiniTableRenderData tableData) {
            int row = 2;
            int col = tableData.getHeader().size();
            BodyContainer bodyContainer = BodyContainerFactory.getBodyContainer(run);
            XWPFTable table = bodyContainer.insertNewTable(run, row, col);
            TableTools.initBasicTable(table, col, tableData.getWidth(), tableData.getStyle());
            Helper.renderRow(table, 0, tableData.getHeader());
            TableTools.mergeCellsHorizonal(table, 1, 0, col - 1);
            XWPFTableCell cell = table.getRow(1).getCell(0);
            cell.setText(tableData.getNoDatadesc());
        }

        public static void renderRow(XWPFTable table, int row, RowRenderData rowData) {
            if (null == rowData || rowData.size() <= 0) {
                return;
            }
            XWPFTableRow tableRow = table.getRow(row);
            Objects.requireNonNull(tableRow, "Row [" + row + "] do not exist in the table");
            TableStyle rowStyle = rowData.getRowStyle();
            List<CellRenderData> cellDatas = rowData.getCells();
            XWPFTableCell cell = null;
            for (int i = 0; i < cellDatas.size(); ++i) {
                cell = tableRow.getCell(i);
                Objects.requireNonNull(cell, "Cell [" + i + "] do not exist at row " + row);
                Helper.renderCell(cell, cellDatas.get(i), rowStyle);
            }
        }

        public static void renderCell(XWPFTableCell cell, CellRenderData cellData, TableStyle rowStyle) {
            TextRenderData renderData;
            TableStyle cellStyle;
            TableStyle tableStyle = cellStyle = null == cellData.getCellStyle() ? rowStyle : cellData.getCellStyle();
            if (null != cellStyle && null != cellStyle.getBackgroundColor()) {
                cell.setColor(cellStyle.getBackgroundColor());
            }
            if (StringUtils.isBlank((CharSequence)(renderData = cellData.getCellText()).getText())) {
                return;
            }
            CTTc ctTc = cell.getCTTc();
            CTP ctP = ctTc.sizeOfPArray() == 0 ? ctTc.addNewP() : ctTc.getPArray(0);
            XWPFParagraph par = new XWPFParagraph(ctP, (IBody)cell);
            StyleUtils.styleTableParagraph(par, cellStyle);
            TextRenderPolicy.Helper.renderTextRun(par.createRun(), renderData);
        }

        private static int getMaxColumFromData(List<RowRenderData> datas) {
            int maxColom = 0;
            for (RowRenderData obj : datas) {
                if (null == obj || obj.size() <= maxColom) continue;
                maxColom = obj.size();
            }
            return maxColom;
        }
    }
}

