/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.resolver;

import com.deepoove.poi.config.Configure;
import com.deepoove.poi.resolver.ElementTemplateFactory;
import com.deepoove.poi.template.ChartTemplate;
import com.deepoove.poi.template.PictureTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import java.util.Set;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class DefaultElementTemplateFactory
implements ElementTemplateFactory {
    public static final char EMPTY_CHAR = '\u0000';
    private final Configure config;

    public DefaultElementTemplateFactory(Configure config) {
        this.config = config;
    }

    @Override
    public RunTemplate createRunTemplate(String tag, XWPFRun run) {
        RunTemplate template = new RunTemplate();
        Set<Character> gramerChars = this.config.getGramerChars();
        Character symbol = Character.valueOf('\u0000');
        if (!"".equals(tag)) {
            char fisrtChar = tag.charAt(0);
            for (Character chara : gramerChars) {
                if (!chara.equals(Character.valueOf(fisrtChar))) continue;
                symbol = Character.valueOf(fisrtChar);
                break;
            }
        }
        template.setSource(this.config.getGramerPrefix() + tag + this.config.getGramerSuffix());
        template.setTagName(symbol.equals(Character.valueOf('\u0000')) ? tag : tag.substring(1));
        template.setSign(symbol);
        template.setRun(run);
        return template;
    }

    @Override
    public PictureTemplate createPicureTemplate(String tag, XWPFPicture pic) {
        PictureTemplate template = new PictureTemplate();
        template.setSource(this.config.getGramerPrefix() + tag + this.config.getGramerSuffix());
        template.setTagName(tag);
        template.setSign(Character.valueOf('\u0000'));
        template.setPicture(pic);
        return template;
    }

    @Override
    public ChartTemplate createChartTemplate(String tag, XWPFChart chart, XWPFRun run) {
        ChartTemplate template = new ChartTemplate(tag, chart, run);
        template.setSource(this.config.getGramerPrefix() + tag + this.config.getGramerSuffix());
        template.setSign(Character.valueOf('\u0000'));
        return template;
    }
}

