/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.util.ParagraphUtils;
import com.deepoove.poi.util.ReflectionUtils;
import com.deepoove.poi.xwpf.BodyContainer;
import java.util.List;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

public class CellBodyContainer
implements BodyContainer {
    XWPFTableCell cell;

    public CellBodyContainer(XWPFTableCell cell) {
        this.cell = cell;
    }

    @Override
    public int getPosOfParagraphCTP(CTP startCtp) {
        List bodyElements = this.cell.getBodyElements();
        for (int i = 0; i < bodyElements.size(); ++i) {
            IBodyElement current = (IBodyElement)bodyElements.get(i);
            if (current.getElementType() != BodyElementType.PARAGRAPH || !((XWPFParagraph)current).getCTP().equals(startCtp)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void removeBodyElement(int pos) {
        List<IBodyElement> bodyElements = this.getBodyElements();
        if (pos >= 0 && pos < bodyElements.size()) {
            int indexOf;
            BodyElementType type = bodyElements.get(pos).getElementType();
            if (type == BodyElementType.TABLE) {
                indexOf = this.cell.getTables().indexOf(bodyElements.get(pos));
                List tables = (List)ReflectionUtils.getValue("tables", this.cell);
                tables.remove(indexOf);
                this.cell.getCTTc().removeTbl(indexOf);
            }
            if (type == BodyElementType.PARAGRAPH) {
                indexOf = this.cell.getParagraphs().indexOf(bodyElements.get(pos));
                List paragraphs = (List)ReflectionUtils.getValue("paragraphs", this.cell);
                paragraphs.remove(indexOf);
                this.cell.getCTTc().removeP(indexOf);
            }
            bodyElements.remove(pos);
        }
    }

    @Override
    public int getPosOfParagraph(XWPFParagraph startParagraph) {
        return this.getPosOfParagraphCTP(startParagraph.getCTP());
    }

    @Override
    public List<IBodyElement> getBodyElements() {
        return (List)ReflectionUtils.getValue("bodyElements", this.cell);
    }

    @Override
    public XWPFParagraph insertNewParagraph(XmlCursor insertPostionCursor) {
        return this.cell.insertNewParagraph(insertPostionCursor);
    }

    @Override
    public int getParaPos(XWPFParagraph insertNewParagraph) {
        List paragraphs = this.cell.getParagraphs();
        for (int i = 0; i < paragraphs.size(); ++i) {
            if (paragraphs.get(i) != insertNewParagraph) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setParagraph(XWPFParagraph p, int paraPos) {
        List paragraphs = (List)ReflectionUtils.getValue("paragraphs", this.cell);
        paragraphs.set(paraPos, p);
        CTTc ctTc = this.cell.getCTTc();
        ctTc.setPArray(paraPos, p.getCTP());
    }

    @Override
    public IBody getTarget() {
        return this.cell;
    }

    @Override
    public void updateBodyElements(IBodyElement insertNewParagraph, IBodyElement copy) {
        int pos = -1;
        List<IBodyElement> bodyElements = this.getBodyElements();
        for (int i = 0; i < bodyElements.size(); ++i) {
            if (bodyElements.get(i) != insertNewParagraph) continue;
            pos = i;
        }
        if (-1 != pos) {
            bodyElements.set(pos, copy);
        }
    }

    @Override
    public XWPFTable insertNewTbl(XmlCursor insertPostionCursor) {
        return this.cell.insertNewTbl(insertPostionCursor);
    }

    @Override
    public int getTablePos(XWPFTable insertNewTbl) {
        List tables = this.cell.getTables();
        for (int i = 0; i < tables.size(); ++i) {
            if (tables.get(i) != insertNewTbl) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setTable(int pos, XWPFTable table) {
        List tables = (List)ReflectionUtils.getValue("tables", this.cell);
        tables.set(pos, table);
        this.cell.getCTTc().setTblArray(pos, table.getCTTbl());
    }

    @Override
    public XWPFTable insertNewTable(XWPFRun run, int row, int col) {
        int i;
        XmlCursor cursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
        XWPFTable table = this.insertNewTbl(cursor);
        List rows = table.getRows();
        for (i = 0; i < rows.size(); ++i) {
            table.removeRow(i);
        }
        for (i = 0; i < row; ++i) {
            XWPFTableRow tabRow = table.getRow(i) == null ? table.createRow() : table.getRow(i);
            for (int k = 0; k < col; ++k) {
                if (tabRow.getCell(k) != null) continue;
                tabRow.createCell();
            }
        }
        return table;
    }

    @Override
    public void clearPlaceholder(XWPFRun run) {
        int lastPos;
        int pos;
        String paragraphText;
        IRunBody parent = run.getParent();
        run.setText("", 0);
        if (parent instanceof XWPFParagraph && "".equals(paragraphText = ParagraphUtils.trimLine((XWPFParagraph)parent)) && this.canRemoveParagraph(pos = this.getPosOfParagraph((XWPFParagraph)parent), lastPos = this.cell.getBodyElements().size() - 1)) {
            this.removeBodyElement(pos);
        }
    }

    private boolean canRemoveParagraph(int pos, int lastPos) {
        return pos < lastPos || pos > 0 && ((IBodyElement)this.cell.getBodyElements().get(pos - 1)).getElementType() == BodyElementType.PARAGRAPH;
    }
}

