/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

public enum PictureType {
    EMF(2),
    WMF(3),
    PICT(4),
    JPEG(5),
    PNG(6),
    DIB(7),
    GIF(8),
    TIFF(9),
    EPS(10),
    BMP(11),
    WPG(12);

    private int type;

    private PictureType(int type) {
        this.type = type;
    }

    public int type() {
        return this.type;
    }

    public String format() {
        return super.name().toLowerCase();
    }

    public static PictureType suggestFileType(String imgFile) {
        PictureType format = null;
        if ((imgFile = imgFile.toLowerCase()).endsWith(".emf")) {
            format = EMF;
        } else if (imgFile.endsWith(".wmf")) {
            format = WMF;
        } else if (imgFile.endsWith(".pict")) {
            format = PICT;
        } else if (imgFile.endsWith(".jpeg") || imgFile.endsWith(".jpg")) {
            format = JPEG;
        } else if (imgFile.endsWith(".png")) {
            format = PNG;
        } else if (imgFile.endsWith(".dib")) {
            format = DIB;
        } else if (imgFile.endsWith(".gif")) {
            format = GIF;
        } else if (imgFile.endsWith(".tiff")) {
            format = TIFF;
        } else if (imgFile.endsWith(".eps")) {
            format = EPS;
        } else if (imgFile.endsWith(".bmp")) {
            format = BMP;
        } else if (imgFile.endsWith(".wpg")) {
            format = WPG;
        } else {
            throw new IllegalArgumentException("Unsupported picture: " + imgFile + ". Expected emf|wmf|pict|jpeg|png|dib|gif|tiff|eps|bmp|wpg");
        }
        return format;
    }
}

