/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.compute;

import com.deepoove.poi.render.compute.EnvModel;
import com.deepoove.poi.render.compute.ReadMapAccessor;
import com.deepoove.poi.render.compute.RenderDataCompute;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpELRenderDataCompute
implements RenderDataCompute {
    private final ExpressionParser parser;
    private final EvaluationContext context;
    private EvaluationContext envContext;
    private boolean isStrict;

    public SpELRenderDataCompute(EnvModel model) {
        this(model, true);
    }

    public SpELRenderDataCompute(EnvModel model, boolean isStrict) {
        this(model, isStrict, Collections.emptyMap());
    }

    public SpELRenderDataCompute(EnvModel model, boolean isStrict, Map<String, Method> spELFunction) {
        this.isStrict = isStrict;
        this.parser = new SpelExpressionParser();
        if (null != model.getEnv() && !model.getEnv().isEmpty()) {
            this.envContext = new StandardEvaluationContext(model.getEnv());
            ((StandardEvaluationContext)this.envContext).addPropertyAccessor((PropertyAccessor)new ReadMapAccessor());
        }
        this.context = new StandardEvaluationContext(model.getRoot());
        ((StandardEvaluationContext)this.context).addPropertyAccessor((PropertyAccessor)new ReadMapAccessor());
        spELFunction.forEach((arg_0, arg_1) -> ((StandardEvaluationContext)((StandardEvaluationContext)this.context)).registerFunction(arg_0, arg_1));
    }

    @Override
    public Object compute(String el) {
        try {
            if (null != this.envContext) {
                try {
                    Object val = this.parser.parseExpression(el).getValue(this.envContext);
                    if (null != val) {
                        return val;
                    }
                }
                catch (Exception val) {
                    // empty catch block
                }
            }
            return this.parser.parseExpression(el).getValue(this.context);
        }
        catch (Exception e) {
            if (this.isStrict) {
                throw e;
            }
            return null;
        }
    }
}

