/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferedImageUtils {
    private static Logger logger = LoggerFactory.getLogger(BufferedImageUtils.class);

    public static byte[] getBufferByteArray(BufferedImage image, String format) {
        String formatName;
        if (null == image) {
            return null;
        }
        String string = formatName = StringUtils.isNotEmpty((CharSequence)format) && format.charAt(0) == '.' ? format.substring(1) : format;
        if (StringUtils.isEmpty((CharSequence)formatName)) {
            formatName = "png";
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, formatName, os);
        }
        catch (Exception e) {
            logger.error("getBufferByteArray error", (Throwable)e);
            return null;
        }
        return os.toByteArray();
    }

    public static BufferedImage getUrlBufferedImage(String urlPath) {
        URL url = null;
        BufferedImage bufferImage = null;
        try {
            url = new URL(urlPath);
            bufferImage = ImageIO.read(url);
            return bufferImage;
        }
        catch (Exception e) {
            logger.error("getUrlBufferedImage error, {}, {}", (Object)urlPath, (Object)e);
            return null;
        }
    }

    public static BufferedImage getLocalBufferedImage(File res) {
        try {
            BufferedImage read = ImageIO.read(res);
            return read;
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFound", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("getLocalBufferedImage IO error", (Throwable)e);
        }
        return null;
    }

    public static BufferedImage newBufferImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 5);
        return image;
    }
}

