/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.codec.binary.Base64;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteUtils {
    private static Logger logger = LoggerFactory.getLogger(ByteUtils.class);

    public static byte[] getUrlByteArray(String urlPath) {
        try {
            return ByteUtils.toByteArray(ByteUtils.getUrlStream(urlPath));
        }
        catch (IOException e) {
            logger.error("getUrlPictureStream error,{},{}", (Object)urlPath, (Object)e);
            return null;
        }
    }

    public static byte[] getLocalByteArray(File res) {
        Path path = res.toPath();
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            logger.error("readAllBytes error", (Throwable)e);
            return null;
        }
    }

    public static byte[] getBase64ByteArray(String base64) {
        boolean isBase64;
        String encodingPrefix = "base64,";
        if (base64.contains(encodingPrefix)) {
            int contentStartIndex = base64.indexOf(encodingPrefix) + encodingPrefix.length();
            base64 = base64.substring(contentStartIndex);
        }
        if (isBase64 = Base64.isBase64((String)base64)) {
            return Base64.decodeBase64((String)base64);
        }
        return null;
    }

    public static byte[] toByteArray(InputStream is) {
        if (null == is) {
            return null;
        }
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            logger.error("toByteArray error", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error("close stream error", (Throwable)e);
            }
        }
        return null;
    }

    public static InputStream getUrlStream(String urlPath) throws IOException {
        URL url = new URL(urlPath);
        return url.openConnection().getInputStream();
    }
}

