/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.processor;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.render.compute.EnvModel;
import com.deepoove.poi.render.compute.RenderDataCompute;
import com.deepoove.poi.render.processor.DefaultTemplateProcessor;
import com.deepoove.poi.render.processor.DocumentProcessor;
import com.deepoove.poi.render.processor.IterableContext;
import com.deepoove.poi.render.processor.Iteration;
import com.deepoove.poi.resolver.Resolver;
import com.deepoove.poi.template.IterableTemplate;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.BodyContainerFactory;
import com.deepoove.poi.xwpf.ParentContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIterableProcessor
extends DefaultTemplateProcessor
implements Iteration {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractIterableProcessor(XWPFTemplate template, Resolver resolver, RenderDataCompute renderDataCompute) {
        super(template, resolver, renderDataCompute);
    }

    @Override
    public void visit(IterableTemplate iterableTemplate) {
        BodyContainer bodyContainer = BodyContainerFactory.getBodyContainer(iterableTemplate);
        Object compute = this.renderDataCompute.compute(iterableTemplate.getStartMark().getTagName());
        if (null == compute || compute instanceof Boolean && !((Boolean)compute).booleanValue()) {
            this.handleNever(iterableTemplate, bodyContainer);
        } else if (compute instanceof Iterable) {
            this.handleIterable(iterableTemplate, bodyContainer, (Iterable)compute);
        } else if (compute instanceof Boolean && ((Boolean)compute).booleanValue()) {
            this.handleOnceWithScope(iterableTemplate, this.renderDataCompute);
        } else {
            this.handleOnce(iterableTemplate, compute);
        }
        this.afterHandle(iterableTemplate, bodyContainer);
    }

    protected void afterHandle(IterableTemplate iterableTemplate, BodyContainer bodyContainer) {
        bodyContainer.clearPlaceholder(iterableTemplate.getStartRun());
        bodyContainer.clearPlaceholder(iterableTemplate.getEndRun());
    }

    protected abstract void handleNever(IterableTemplate var1, BodyContainer var2);

    protected abstract void handleIterable(IterableTemplate var1, BodyContainer var2, Iterable<?> var3);

    protected void foreach(IterableTemplate iterableTemplate, ParentContext parentContext, IterableContext context, Iterator<?> iterator) {
        HashMap<String, Object> env = new HashMap<String, Object>();
        int index = 0;
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            Object root = iterator.next();
            hasNext = iterator.hasNext();
            env.put("_is_first", index == 0);
            env.put("_is_last", !hasNext);
            env.put("_has_next", hasNext);
            env.put("_is_even_item", index % 2 == 1);
            env.put("_is_odd_item", index % 2 == 0);
            env.put("_index", index++);
            this.next(iterableTemplate, parentContext, context, EnvModel.of(root, env));
        }
    }

    protected void handleOnce(IterableTemplate iterableTemplate, Object compute) {
        this.process(iterableTemplate.getTemplates(), compute);
    }

    protected void handleOnceWithScope(IterableTemplate iterableTemplate, RenderDataCompute dataCompute) {
        new DocumentProcessor(this.template, this.resolver, dataCompute).process(iterableTemplate.getTemplates());
    }

    protected void process(List<MetaTemplate> templates, Object model) {
        RenderDataCompute dataCompute = this.template.getConfig().getRenderDataComputeFactory().newCompute(model);
        new DocumentProcessor(this.template, this.resolver, dataCompute).process(templates);
    }
}

