/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.swagger.dubbo.config;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.deepoove.swagger.dubbo.http.ReferenceManager;
import io.swagger.config.SwaggerConfig;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.Swagger;
import java.text.MessageFormat;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DubboPropertyConfig
implements SwaggerConfig {
    @Value(value="${swagger.dubbo.application.version:}")
    private String version;
    @Value(value="${swagger.dubbo.application.groupId:}")
    private String groupId;
    @Value(value="${swagger.dubbo.application.artifactId:}")
    private String artifactId;
    @Autowired
    private ServletContext servletContext;
    private static String mavenDependency = "&lt;dependency&gt;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;{0}&lt;/groupId&gt;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;{1}&lt;/artifactId&gt;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;{2}&lt;/version&gt;<br/>&lt;/dependency&gt;<br/>";

    public Swagger configure(Swagger swagger) {
        ApplicationConfig application = ReferenceManager.getInstance().getApplication();
        if (null != application) {
            Info info = swagger.getInfo();
            if (info == null) {
                info = new Info();
                swagger.setInfo(info);
            }
            info.setTitle(application.getName());
            String string = this.version = StringUtils.isNotBlank((CharSequence)this.version) ? this.version : application.getVersion();
            if (StringUtils.isNotBlank((CharSequence)this.groupId) && StringUtils.isNotBlank((CharSequence)this.artifactId) && StringUtils.isNotBlank((CharSequence)this.version)) {
                info.setDescription(MessageFormat.format(mavenDependency, this.groupId, this.artifactId, this.version));
            }
            info.setVersion(StringUtils.isNotBlank((CharSequence)this.version) ? this.version : "");
            Contact contact = new Contact();
            info.setContact(contact);
            contact.setName(application.getOwner());
        }
        this.setBashPath(swagger);
        return swagger;
    }

    private void setBashPath(Swagger swagger) {
        if (StringUtils.isEmpty((CharSequence)swagger.getBasePath())) {
            swagger.setBasePath(StringUtils.isEmpty((CharSequence)this.servletContext.getContextPath()) ? "/" : this.servletContext.getContextPath());
        }
    }

    public String getFilterClass() {
        return null;
    }
}

