/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.api;

import com.deevvi.device.detector.engine.api.DeviceDetectorResult;
import com.deevvi.device.detector.engine.parser.BotParser;
import com.deevvi.device.detector.engine.parser.OperatingSystemParser;
import com.deevvi.device.detector.engine.parser.VendorFragmentsParser;
import com.deevvi.device.detector.engine.parser.client.BrowserEngineParser;
import com.deevvi.device.detector.engine.parser.client.BrowserParser;
import com.deevvi.device.detector.engine.parser.client.FeedReaderParser;
import com.deevvi.device.detector.engine.parser.client.LibraryParser;
import com.deevvi.device.detector.engine.parser.client.MediaPlayerParser;
import com.deevvi.device.detector.engine.parser.client.MobileAppParser;
import com.deevvi.device.detector.engine.parser.client.PIMDeviceParser;
import com.deevvi.device.detector.engine.parser.device.CameraParser;
import com.deevvi.device.detector.engine.parser.device.CarParser;
import com.deevvi.device.detector.engine.parser.device.ConsoleParser;
import com.deevvi.device.detector.engine.parser.device.DeviceType;
import com.deevvi.device.detector.engine.parser.device.MobileParser;
import com.deevvi.device.detector.engine.parser.device.NotebookParser;
import com.deevvi.device.detector.engine.parser.device.PortableMediaPlayerParser;
import com.deevvi.device.detector.engine.parser.device.ShellTvParser;
import com.deevvi.device.detector.engine.parser.device.TelevisionParser;
import com.deevvi.device.detector.engine.parser.facade.ParserFacade;
import com.deevvi.device.detector.engine.parser.facade.ParserPair;
import com.deevvi.device.detector.engine.utils.ConfigUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public final class DeviceDetectorParser {
    private static final List<String> DESKTOP_OS_LIST = ConfigUtils.fetchListFromFile("/configs/desktopOperatingSystems");
    private static final List<String> APPLE_OS_LIST = ConfigUtils.fetchListFromFile("/configs/appleOperatingSystems");
    private static final List<String> TV_BROWSER_LIST = ConfigUtils.fetchListFromFile("/configs/tvBrowserList");
    private static final Pattern MOBILE_PATTERN = Pattern.compile("(?:^|[^A-Z_-])(?:Android( [\\.0-9]+)?; Mobile;)", 2);
    private static final Pattern TOUCH_PATTERN = Pattern.compile("(?:^|[^A-Z_-])(?:Touch)", 2);
    private static final Pattern ANDROID_PATTERN = Pattern.compile("(?:^|[^A-Z_-])(?:Android( [\\.0-9]+)?; Tablet;)", 2);
    private static final Pattern OPERA_PATTERN = Pattern.compile("(?:^|[^A-Z_-])(?:Opera Tablet)", 2);
    private static final Pattern SAFARI_SMARTPHONE_PATTERN = Pattern.compile("(?:^|[^A-Z_-])(?:Mobile|eliboM) Safari", 2);
    private static final Pattern SAFARI_TABLET_PATTERN = Pattern.compile("(?:^|[^A-Z_-])(?!Mobile )Safari", 2);
    private static final Pattern CHROME_PATTERN = Pattern.compile("(?:^|[^A-Z_-])(?:Chrome/[\\.0-9]*)", 2);
    private static final Pattern SMART_TV_OR_TIZIEN_TV = Pattern.compile("(?:^|[^A-Z_-])(SmartTV|Tizen.+ TV .+$)", 2);
    private static final Pattern OPERA_TV_STORE = Pattern.compile("(?:^|[^A-Z_-])(?:Opera TV Store)", 2);
    private static final Pattern DESKTOP_FRAGMENT = Pattern.compile("(?:^|[^A-Z_-])(?:Desktop (x(?:32|64)|WOW64);)", 2);
    private final BotParser botParser = new BotParser();
    private final OperatingSystemParser operatingSystemParser = new OperatingSystemParser();
    private final VendorFragmentsParser vendorFragmentsParser = new VendorFragmentsParser();
    private final ParserFacade deviceParser;
    private final ParserFacade clientParser;

    private DeviceDetectorParser() {
        ArrayList parsers = Lists.newArrayList();
        parsers.add(new ParserPair(new TelevisionParser(), 1));
        parsers.add(new ParserPair(new ShellTvParser(), 2));
        parsers.add(new ParserPair(new NotebookParser(), 3));
        parsers.add(new ParserPair(new ConsoleParser(), 4));
        parsers.add(new ParserPair(new CarParser(), 5));
        parsers.add(new ParserPair(new CameraParser(), 6));
        parsers.add(new ParserPair(new PortableMediaPlayerParser(), 7));
        parsers.add(new ParserPair(new MobileParser(), 8));
        this.deviceParser = new ParserFacade(parsers);
        ArrayList clientsList = Lists.newArrayList();
        clientsList.add(new ParserPair(new FeedReaderParser(), 1));
        clientsList.add(new ParserPair(new MobileAppParser(), 2));
        clientsList.add(new ParserPair(new MediaPlayerParser(), 3));
        clientsList.add(new ParserPair(new PIMDeviceParser(), 4));
        clientsList.add(new ParserPair(new BrowserParser(new BrowserEngineParser()), 5));
        clientsList.add(new ParserPair(new LibraryParser(), 6));
        this.clientParser = new ParserFacade(clientsList);
    }

    public static DeviceDetectorParser getClient() {
        return new DeviceDetectorParser();
    }

    public DeviceDetectorResult parse(String userAgent) {
        if (StringUtils.isEmpty((CharSequence)userAgent)) {
            return DeviceDetectorResult.fromEmptyResult();
        }
        Map<String, String> botMap = this.botParser.parse(userAgent);
        if (!botMap.isEmpty()) {
            return DeviceDetectorResult.fromBotResult(botMap);
        }
        return this.tryDetectDevice(userAgent);
    }

    private DeviceDetectorResult tryDetectDevice(String userAgent) {
        String osName;
        Map<String, String> osDetails = this.operatingSystemParser.parse(userAgent);
        Map<String, String> clientDetails = this.clientParser.parse(userAgent);
        Map<String, String> deviceDetails = this.deviceParser.parse(userAgent);
        if (this.noBrandDetected(deviceDetails)) {
            Map<String, String> vendorResults = this.vendorFragmentsParser.parse(userAgent);
            String vendor = null;
            if (!vendorResults.isEmpty()) {
                vendor = vendorResults.get("vendor");
            }
            if (StringUtils.isNotBlank(vendor)) {
                deviceDetails.put("brand", vendor);
            } else if (this.isRunningMacOS(osDetails)) {
                deviceDetails.put("brand", "Apple");
            }
        }
        if (this.noDeviceTypeDetected(deviceDetails)) {
            if (this.isAndroid(osDetails) && this.hasChromePattern(userAgent)) {
                if (this.isSafariSmartphone(userAgent)) {
                    deviceDetails.put("deviceType", DeviceType.SMARTPHONE.getDeviceName());
                } else if (this.isSafariTablet(userAgent)) {
                    deviceDetails.put("deviceType", DeviceType.TABLET.getDeviceName());
                }
            } else if (this.hasAndroidTableFragment(userAgent) || this.hasOperaTabletFragment(userAgent)) {
                deviceDetails.put("deviceType", DeviceType.TABLET.getDeviceName());
            } else if (this.hasAndroidMobileFragment(userAgent)) {
                deviceDetails.put("deviceType", DeviceType.SMARTPHONE.getDeviceName());
            }
        }
        if (this.noDeviceTypeDetected(deviceDetails) && this.isAndroid(osDetails) && osDetails.containsKey("version")) {
            String stringVersion = osDetails.get("version");
            DefaultArtifactVersion defaultVersion = new DefaultArtifactVersion(stringVersion);
            if (defaultVersion.compareTo((ArtifactVersion)new DefaultArtifactVersion("2.0")) < 0) {
                deviceDetails.put("deviceType", DeviceType.SMARTPHONE.getDeviceName());
            } else if (defaultVersion.compareTo((ArtifactVersion)new DefaultArtifactVersion("3.0")) >= 0 && defaultVersion.compareTo((ArtifactVersion)new DefaultArtifactVersion("4.0")) < 0) {
                deviceDetails.put("deviceType", DeviceType.TABLET.getDeviceName());
            }
        }
        if (this.isFeaturePhone(deviceDetails) && this.isAndroid(osDetails)) {
            deviceDetails.put("deviceType", DeviceType.SMARTPHONE.getDeviceName());
        }
        if ((osName = osDetails.getOrDefault("name", "")).equals("Java ME") && deviceDetails.isEmpty()) {
            deviceDetails.put("deviceType", DeviceType.FEATURE_PHONE.getDeviceName());
        }
        if (this.noDeviceTypeDetected(deviceDetails) && (osName.equals("Windows RT") || osName.equals("Windows") && new DefaultArtifactVersion(osDetails.getOrDefault("version", "0")).compareTo((ArtifactVersion)new DefaultArtifactVersion("8.0")) >= 0 && this.isTouch(userAgent))) {
            deviceDetails.put("deviceType", DeviceType.TABLET.getDeviceName());
        }
        if (this.isOperaTV(userAgent)) {
            deviceDetails.put("deviceType", DeviceType.TV.getDeviceName());
        }
        if (this.noDeviceTypeDetected(deviceDetails) && this.isTizienOrSmartTv(userAgent)) {
            deviceDetails.put("deviceType", DeviceType.TV.getDeviceName());
        }
        if (this.noDeviceTypeDetected(deviceDetails) && this.isTVBrowser(clientDetails)) {
            deviceDetails.put("deviceType", DeviceType.TV.getDeviceName());
        }
        if (!this.isDesktopDeviceType(deviceDetails) && userAgent.toLowerCase().contains("desktop") && this.hasDesktopFragment(userAgent)) {
            deviceDetails.put("deviceType", DeviceType.DESKTOP.getDeviceName());
        }
        if (this.noDeviceTypeDetected(deviceDetails) && this.isDesktop(osDetails)) {
            deviceDetails.put("deviceType", DeviceType.DESKTOP.getDeviceName());
        }
        return DeviceDetectorResult.fromDevice(osDetails, clientDetails, deviceDetails);
    }

    private boolean hasDesktopFragment(String userAgent) {
        return DESKTOP_FRAGMENT.matcher(userAgent).find();
    }

    private boolean isDesktopDeviceType(Map<String, String> deviceDetails) {
        return deviceDetails.getOrDefault("deviceType", "").equals(DeviceType.DESKTOP.getDeviceName());
    }

    private boolean isTVBrowser(Map<String, String> clientDetails) {
        return TV_BROWSER_LIST.contains(clientDetails.getOrDefault("name", ""));
    }

    private boolean isOperaTV(String userAgent) {
        return OPERA_TV_STORE.matcher(userAgent).find();
    }

    private boolean hasChromePattern(String userAgent) {
        return CHROME_PATTERN.matcher(userAgent).find();
    }

    private boolean isSafariTablet(String userAgent) {
        return SAFARI_TABLET_PATTERN.matcher(userAgent).find();
    }

    private boolean isSafariSmartphone(String userAgent) {
        return SAFARI_SMARTPHONE_PATTERN.matcher(userAgent).find();
    }

    private boolean noDeviceTypeDetected(Map<String, String> deviceDetails) {
        return StringUtils.isEmpty((CharSequence)deviceDetails.getOrDefault("deviceType", ""));
    }

    private boolean noBrandDetected(Map<String, String> deviceDetails) {
        return StringUtils.isEmpty((CharSequence)deviceDetails.getOrDefault("brand", ""));
    }

    private boolean isFeaturePhone(Map<String, String> deviceDetails) {
        return deviceDetails.getOrDefault("deviceType", "").equals(DeviceType.FEATURE_PHONE.getDeviceName());
    }

    private boolean isTizienOrSmartTv(String userAgent) {
        return SMART_TV_OR_TIZIEN_TV.matcher(userAgent).find();
    }

    private boolean isRunningMacOS(Map<String, String> osDetails) {
        String osShortName = osDetails.get("shortName");
        return StringUtils.isNotEmpty((CharSequence)osShortName) && APPLE_OS_LIST.contains(osShortName);
    }

    private boolean hasOperaTabletFragment(String userAgent) {
        return OPERA_PATTERN.matcher(userAgent).find();
    }

    private boolean hasAndroidTableFragment(String userAgent) {
        return ANDROID_PATTERN.matcher(userAgent).find();
    }

    private boolean isTouch(String userAgent) {
        return TOUCH_PATTERN.matcher(userAgent).find();
    }

    private boolean isAndroid(Map<String, String> osDetails) {
        String osFamily = osDetails.get("osFamily");
        return StringUtils.isNotBlank((CharSequence)osFamily) && osFamily.equals("Android");
    }

    private boolean hasAndroidMobileFragment(String userAgent) {
        return MOBILE_PATTERN.matcher(userAgent).find();
    }

    private boolean isDesktop(Map<String, String> osDetails) {
        if (osDetails.isEmpty()) {
            return false;
        }
        String osFamily = osDetails.get("osFamily");
        return StringUtils.isNotEmpty((CharSequence)osFamily) && DESKTOP_OS_LIST.contains(osFamily);
    }
}

