/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.api;

import com.deevvi.device.detector.engine.parser.device.DeviceType;
import com.deevvi.device.detector.engine.utils.ConfigUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeviceDetectorResult {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceDetectorResult.class);
    private static final List<String> MOBILE_ONLY_BROWSER = ConfigUtils.fetchListFromFile("/configs/mobileOnlyBrowsers");
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String BOT_MAP = "botMap";
    private static final String OS_DETAILS = "osDetails";
    private static final String CLIENT_DETAILS = "clientDetails";
    private static final String DEVICE_DETAILS = "deviceDetails";
    private static final String OS = "os";
    private static final String CLIENT = "client";
    private static final String DEVICE = "device";
    private static final Set<String> MOBILE_DEVICE_TYPES = ImmutableSet.of((Object)DeviceType.FEATURE_PHONE.getDeviceName(), (Object)DeviceType.SMARTPHONE.getDeviceName(), (Object)DeviceType.TABLET.getDeviceName(), (Object)DeviceType.PHABLET.getDeviceName(), (Object)DeviceType.CAMERA.getDeviceName(), (Object)DeviceType.PORTABLE_MEDIA_PLAYER.getDeviceName(), (Object[])new String[0]);
    private final Map<String, Map<String, String>> map = Maps.newHashMap();

    private DeviceDetectorResult() {
    }

    static DeviceDetectorResult fromEmptyResult() {
        return new DeviceDetectorResult();
    }

    static DeviceDetectorResult fromBotResult(Map<String, String> botMap) {
        DeviceDetectorResult result = new DeviceDetectorResult();
        result.map.put(BOT_MAP, (Map<String, String>)ImmutableMap.copyOf(botMap));
        return result;
    }

    static DeviceDetectorResult fromDevice(Map<String, String> osDetails, Map<String, String> clientDetails, Map<String, String> deviceDetails) {
        DeviceDetectorResult result = new DeviceDetectorResult();
        result.map.put(OS_DETAILS, (Map<String, String>)ImmutableMap.copyOf(osDetails));
        result.map.put(CLIENT_DETAILS, (Map<String, String>)ImmutableMap.copyOf(clientDetails));
        result.map.put(DEVICE_DETAILS, (Map<String, String>)ImmutableMap.copyOf(deviceDetails));
        return result;
    }

    public String toJSON() {
        if (this.map.containsKey(BOT_MAP)) {
            return this.encodeBotAsJson();
        }
        return this.encodeAsJson();
    }

    public Map<String, String> toMap() {
        if (this.map.containsKey(BOT_MAP)) {
            return this.encodeBotAsMap();
        }
        return this.encodeAsMap();
    }

    public boolean found() {
        return !this.map.isEmpty();
    }

    public boolean isBot() {
        return this.map.containsKey(BOT_MAP);
    }

    public boolean isMobileDevice() {
        return this.map.containsKey(DEVICE_DETAILS) && MOBILE_DEVICE_TYPES.contains(this.map.getOrDefault(DEVICE_DETAILS, Maps.newHashMap()).getOrDefault("deviceType", "")) || MOBILE_ONLY_BROWSER.contains(this.map.getOrDefault(CLIENT_DETAILS, Maps.newHashMap()).getOrDefault("shortName", ""));
    }

    private Map<String, String> encodeBotAsMap() {
        HashMap resultMap = Maps.newHashMap();
        resultMap.put("type", "bot");
        resultMap.putAll(this.map.get(BOT_MAP));
        return ImmutableMap.copyOf((Map)resultMap);
    }

    private Map<String, String> encodeAsMap() {
        HashMap resultMap = Maps.newHashMap();
        resultMap.putAll(this.encodeAsResultMap(this.map.get(OS_DETAILS), OS));
        resultMap.putAll(this.encodeAsResultMap(this.map.get(CLIENT_DETAILS), CLIENT));
        resultMap.putAll(this.encodeAsResultMap(this.map.get(DEVICE_DETAILS), DEVICE));
        return ImmutableMap.copyOf((Map)resultMap);
    }

    private Map<String, String> encodeAsResultMap(Map<String, String> inputMap, String prefix) {
        HashMap map = Maps.newHashMap();
        inputMap.forEach((k, v) -> {
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{v})) {
                map.put(String.format("%s.%s", prefix, k), v);
            }
        });
        return map;
    }

    private String encodeAsJson() {
        ObjectNode responseNode = mapper.createObjectNode();
        if (!this.map.get(OS_DETAILS).isEmpty()) {
            responseNode.set(OS, (JsonNode)this.createNode(this.map.get(OS_DETAILS)));
        }
        if (!this.map.get(CLIENT_DETAILS).isEmpty()) {
            responseNode.set(CLIENT, (JsonNode)this.createNode(this.map.get(CLIENT_DETAILS)));
        }
        if (!this.map.get(DEVICE_DETAILS).isEmpty()) {
            responseNode.set(DEVICE, (JsonNode)this.createNode(this.map.get(DEVICE_DETAILS)));
        }
        return this.encodeToJson((JsonNode)responseNode);
    }

    private ObjectNode createNode(Map<String, String> map) {
        ObjectNode node = mapper.createObjectNode();
        map.forEach((key, value) -> node.set(key, (JsonNode)new TextNode(value)));
        return node;
    }

    private String encodeBotAsJson() {
        return this.encodeToJson((JsonNode)this.createNode(this.map.get(BOT_MAP)));
    }

    private String encodeToJson(JsonNode node) {
        try {
            return mapper.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception on building JSON ", (Throwable)e);
            throw new IllegalArgumentException("Unable to create JSON.");
        }
    }
}

