/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.loader;

import com.deevvi.device.detector.model.exceptions.DeviceDetectorException;
import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public interface Loader {
    public static final Logger LOG = LoggerFactory.getLogger(Loader.class);
    public static final Yaml YAML = new Yaml();

    public String getFilePath();

    default public Object loadFromFile() {
        String filePath = this.getFilePath();
        try {
            LOG.info("Reading configuration from file {}", (Object)this.getFilePath());
            return YAML.load(IOUtils.resourceToString((String)this.getFilePath(), (Charset)Charsets.UTF_8));
        }
        catch (Exception e) {
            throw new DeviceDetectorException(String.format("Unable to read config %s file. Invalid file handler.", filePath));
        }
    }
}

