/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser;

import com.deevvi.device.detector.engine.loader.ListLoader;
import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.model.Bot;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class BotParser
implements Parser,
ListLoader<Bot> {
    private final List<Bot> bots = this.streamToList();

    @Override
    public Map<String, String> parse(String userAgent) {
        return this.bots.stream().filter(bot -> bot.getPattern().matcher(userAgent).find()).findFirst().map(this::encodeResponse).orElse(Maps.newHashMap());
    }

    @Override
    public Bot toObject(Object rawObject) {
        Map map = (Map)rawObject;
        String name = (String)map.get("name");
        String category = (String)map.get("category");
        String url = (String)map.get("url");
        String producerUrl = null;
        String producerName = null;
        if (map.containsKey("producer")) {
            Map producerMap = (Map)map.get("producer");
            producerName = (String)producerMap.get("name");
            producerUrl = (String)producerMap.get("url");
        }
        return new Bot.Builder().withRawRegex((String)map.get("regex")).withName(name).withCategory(category).withUrl(url).withProducerName(producerName).withProducerUrl(producerUrl).build();
    }

    @Override
    public String getFilePath() {
        return "/regexes/bots.yml";
    }

    private Map<String, String> encodeResponse(Bot bot) {
        HashMap map = Maps.newHashMap();
        map.put("name", bot.getName());
        if (StringUtils.isNotEmpty((CharSequence)bot.getCategory())) {
            map.put("category", bot.getCategory());
        }
        if (StringUtils.isNotEmpty((CharSequence)bot.getUrl())) {
            map.put("url", bot.getUrl());
        }
        if (StringUtils.isNotEmpty((CharSequence)bot.getProducerName())) {
            map.put("producerName", bot.getProducerName());
        }
        if (StringUtils.isNotEmpty((CharSequence)bot.getProducerUrl())) {
            map.put("producerUrl", bot.getProducerUrl());
        }
        return map;
    }
}

