/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser;

import com.deevvi.device.detector.engine.loader.ListLoader;
import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.engine.utils.ConfigUtils;
import com.deevvi.device.detector.engine.utils.Tuple;
import com.deevvi.device.detector.model.OperatingSystem;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class OperatingSystemParser
implements Parser,
ListLoader<OperatingSystem> {
    private static final Set<String> notCapitalizedOS = ImmutableSet.of((Object)"", (Object)"iOS", (Object)"webOS", (Object)"palmOS", (Object)"watchOS", (Object)"iPadOS", (Object[])new String[]{"tvOS"});
    private static final Map<String, Pattern> platformMapping = new ImmutableMap.Builder().put((Object)"ARM", (Object)Pattern.compile("(?:^|[^A-Z0-9\\-_]|[^A-Z0-9\\-]_|sprd-)(?:arm|aarch64|Apple ?TV|Watch ?OS|Watch1,[12])", 2)).put((Object)"MIPS", (Object)Pattern.compile("(?:^|[^A-Z0-9\\-_]|[^A-Z0-9\\-]_|sprd-)(?:mips)", 2)).put((Object)"SuperH", (Object)Pattern.compile("(?:^|[^A-Z0-9\\-_]|[^A-Z0-9\\-]_|sprd-)(?:sh4)", 2)).put((Object)"x64", (Object)Pattern.compile("(?:^|[^A-Z0-9\\-_]|[^A-Z0-9\\-]_|sprd-)(?:64-?bit|WOW64|(?:Intel)?x64|win64|amd64|x86_?64)", 2)).put((Object)"x86", (Object)Pattern.compile("(?:^|[^A-Z0-9\\-_]|[^A-Z0-9\\-]_|sprd-)(?:.+32bit|.+win32|(?:i[0-9]|x)86|i86pc)", 2)).build();
    private static final Map<String, String> operatingSystemsNames = ConfigUtils.fetchMapFromFile("/configs/availableOperatingSystems");
    private static final Map<String, String> operatingSystemsFamilies = ConfigUtils.fetchMapFromFile("/configs/operatingSystemsFamilies");
    private final List<OperatingSystem> operatingSystems = this.streamToList();

    @Override
    public Map<String, String> parse(String userAgent) {
        return this.operatingSystems.stream().map(os -> new Tuple<OperatingSystem>((OperatingSystem)os, os.getPattern().matcher(userAgent))).filter(t -> t.getMatcher().find()).findFirst().map(t -> this.buildResult(userAgent, (Tuple<OperatingSystem>)t)).orElse(Maps.newHashMap());
    }

    @Override
    public OperatingSystem toObject(Object rawObject) {
        Map map = (Map)rawObject;
        Map<Pattern, String> versions = this.loadVersions(map);
        return new OperatingSystem.Builder().withPattern(this.toPattern((String)map.get("regex"))).withName((String)map.get("name")).withVersion((String)map.get("version")).withVersions(versions).build();
    }

    private Map<Pattern, String> loadVersions(Map<String, Object> map) {
        LinkedHashMap versions = Maps.newLinkedHashMap();
        if (map.containsKey("versions")) {
            List list = (List)map.get("versions");
            list.forEach(item -> {
                String cfr_ignored_0 = (String)versions.put(this.toPattern((String)item.get("regex")), item.get("version"));
            });
        }
        return versions;
    }

    @Override
    public String getFilePath() {
        return "/regexes/operating-systems.yml";
    }

    private Map<String, String> buildResult(String userAgent, Tuple<OperatingSystem> t) {
        HashMap map = Maps.newHashMap();
        Optional<String> name = this.buildName(this.buildVersion(t.getMatcher(), t.get().getName()));
        name.ifPresent(val -> {
            map.put("name", val);
            if (operatingSystemsNames.containsKey(val)) {
                map.put("shortName", operatingSystemsNames.get(val));
            }
            map.put("osFamily", operatingSystemsFamilies.getOrDefault(operatingSystemsNames.get(val), "Unknown"));
        });
        Optional<String> version = Optional.ofNullable(this.buildVersion(t.getMatcher(), t.get().getVersion()).map(Parser::clear).orElse(this.checkHasVersions(userAgent, t)));
        version.ifPresent(val -> map.put("version", val));
        map.put("platform", this.buildPlatform(userAgent));
        return map;
    }

    private String checkHasVersions(String userAgent, Tuple<OperatingSystem> t) {
        for (Map.Entry<Pattern, String> entry : t.get().getVersions().entrySet()) {
            Matcher matcher = entry.getKey().matcher(userAgent);
            if (!matcher.find()) continue;
            return this.buildVersion(matcher, entry.getValue()).orElse(null);
        }
        return null;
    }

    private Optional<String> buildName(Optional<String> name) {
        if (name.isPresent() && notCapitalizedOS.contains(StringUtils.trimToEmpty((String)name.get()))) {
            return name;
        }
        return name.map(this::capitalize);
    }

    private String buildPlatform(String userAgent) {
        for (Map.Entry<String, Pattern> entry : platformMapping.entrySet()) {
            Matcher matcher = entry.getValue().matcher(userAgent);
            if (!matcher.find()) continue;
            return entry.getKey();
        }
        return "";
    }
}

