/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser;

import com.deevvi.device.detector.model.PatternBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public interface Parser
extends PatternBuilder {
    public static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\$[0-9]", 2);
    public static final String DEFAULT = "default";
    public static final String DEVICE_TYPE = "deviceType";
    public static final String BROWSER = "browser";
    public static final String CATEGORY = "category";
    public static final String PRODUCER_NAME = "producerName";
    public static final String NAME = "name";
    public static final String URL = "url";
    public static final String PRODUCER_URL = "producerUrl";
    public static final String MODEL = "model";
    public static final String BRAND = "brand";
    public static final String VERSION = "version";
    public static final String PLATFORM = "platform";
    public static final String OS_FAMILY = "osFamily";
    public static final String ENGINE = "engine";
    public static final String ENGINE_VERSION = "engineVersion";
    public static final String ENGINE_NAME = "engineName";
    public static final String SHORT_NAME = "shortName";
    public static final String BROWSER_FAMILY = "browserFamily";
    public static final String UNKNOWN = "Unknown";
    public static final String VENDOR = "vendor";
    public static final String EMPTY_STRING = "";
    public static final String REGEX = "regex";
    public static final String DEVICE = "device";
    public static final String VERSIONS = "versions";
    public static final String MODELS = "models";
    public static final String TYPE = "type";
    public static final String PRODUCER = "producer";

    public Map<String, String> parse(String var1);

    default public boolean hasValidVersion(String version) {
        return StringUtils.isNotBlank((CharSequence)version);
    }

    default public Optional<String> buildVersion(Matcher matcher, String version) {
        if (!this.hasValidVersion(version)) {
            return Optional.empty();
        }
        int index = this.getStartIndex(version);
        String builtVersion = version;
        String group = "$";
        String regex_group = "\\$";
        while (builtVersion.contains(group + index)) {
            String current = matcher.group(index);
            if (current == null) {
                if (builtVersion.equals(version)) {
                    return Optional.empty();
                }
                current = EMPTY_STRING;
            }
            builtVersion = builtVersion.replaceAll(regex_group + index, current);
            ++index;
        }
        if (builtVersion.endsWith(".")) {
            return Optional.of(builtVersion.substring(0, builtVersion.length() - 1));
        }
        return Optional.of(builtVersion.trim().replaceAll("_", "."));
    }

    default public int getStartIndex(String version) {
        int index = 0;
        if (version.contains("$")) {
            while (!version.contains("$" + ++index)) {
            }
        }
        return index;
    }

    default public Optional<String> buildModelWithPattern(Matcher matcher, String model) {
        int index = this.getStartIndex(model);
        if (index == 0) {
            return Optional.of(Parser.clear(model));
        }
        String group = "$";
        String regex_group = "\\$";
        while (model.contains(group + index)) {
            String current = matcher.group(index);
            if (current == null) {
                return Optional.empty();
            }
            model = model.replaceAll(regex_group + index, current);
            ++index;
        }
        return Optional.of(Parser.clear(model.trim()));
    }

    default public Optional<String> buildByMatcher(Matcher matcher, String item) {
        if (item == null) {
            return Optional.empty();
        }
        if (!item.contains("$")) {
            return Optional.of(item.trim());
        }
        for (int i = 1; i <= 3; ++i) {
            if (!item.contains("$" + i)) continue;
            String group = matcher.group(i);
            String replacement = Optional.ofNullable(group).orElse(EMPTY_STRING);
            item = item.replace("$" + i, replacement);
        }
        return Optional.of(item.trim());
    }

    public static boolean checkContainsPlaceholder(String input) {
        return StringUtils.isNotEmpty((CharSequence)input) && TEMPLATE_PATTERN.matcher(input).find();
    }

    public static String clear(String raw) {
        if (raw == null) {
            return null;
        }
        String newString = raw.replaceAll("_", " ");
        if (newString.endsWith(" TD")) {
            return newString.replaceAll(" TD", EMPTY_STRING);
        }
        return newString;
    }

    default public String capitalize(String raw) {
        return StringUtils.isEmpty((CharSequence)raw) ? raw : Character.toUpperCase(raw.charAt(0)) + raw.substring(1);
    }

    default public boolean preMatchOverall(List<String> regexes, String userAgent) {
        Pattern pattern = this.toPattern(Joiner.on((String)"|").join((Iterable)Lists.reverse(regexes)));
        return pattern.matcher(userAgent).find();
    }
}

