/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser;

import com.deevvi.device.detector.engine.loader.MapLoader;
import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.model.PatternBuilder;
import com.deevvi.device.detector.model.VendorFragments;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VendorFragmentsParser
implements Parser,
PatternBuilder,
MapLoader<VendorFragments> {
    private final List<VendorFragments> vendorFragments = this.streamToList();

    @Override
    public Map<String, String> parse(String userAgent) {
        HashMap map = Maps.newHashMap();
        this.vendorFragments.forEach(vf -> vf.getPatterns().forEach(pattern -> {
            Matcher matcher = pattern.matcher(userAgent);
            if (matcher.find()) {
                map.put("vendor", vf.getVendor());
            }
        }));
        return map;
    }

    @Override
    public String getFilePath() {
        return "/regexes/vendor-fragments.yml";
    }

    @Override
    public VendorFragments toObject(String key, Object value) {
        ArrayList patterns = Lists.newArrayList();
        ((List)value).forEach(val -> patterns.add(Pattern.compile(String.format("(?:^|[^A-Z0-9\\-_]|[^A-Z0-9\\-]_|sprd-|MZ-)(?:%s)", (val + "[^a-z0-9]+").replaceAll("/", "\\\\/")), 2)));
        return new VendorFragments.Builder().withVendor(key).withPatterns(patterns).build();
    }
}

