/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.client;

import com.deevvi.device.detector.engine.loader.ListLoader;
import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.engine.utils.ConfigUtils;
import com.deevvi.device.detector.model.client.BrowserEngine;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public final class BrowserEngineParser
implements Parser,
ListLoader<BrowserEngine> {
    private final List<String> availableEngines = ConfigUtils.fetchListFromFile("/configs/browserEngines.txt");
    private final List<BrowserEngine> browserEngines = this.streamToList();

    @Override
    public Map<String, String> parse(String userAgent) {
        return (Map)this.browserEngines.stream().filter(engine -> engine.getPattern().matcher(userAgent).find() && this.availableEngines.contains(engine.getName())).findFirst().map(val -> ImmutableMap.of((Object)"engineName", (Object)val.getName())).orElse(ImmutableMap.of());
    }

    @Override
    public BrowserEngine toObject(Object rawObject) {
        Map map = (Map)rawObject;
        String rawRegex = (String)map.get("regex");
        return new BrowserEngine.Builder().withName((String)map.get("name")).withRawRegex(rawRegex).build();
    }

    @Override
    public String getFilePath() {
        return "/regexes/client/browser_engine.yml";
    }
}

