/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.client;

import com.deevvi.device.detector.engine.loader.ListLoader;
import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.engine.parser.client.BrowserEngineParser;
import com.deevvi.device.detector.engine.utils.ConfigUtils;
import com.deevvi.device.detector.engine.utils.Tuple;
import com.deevvi.device.detector.model.client.Browser;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public final class BrowserParser
implements Parser,
ListLoader<Browser> {
    private static final String GECKO_ENGINE = "Gecko";
    private static final String ENGINE_VERSION_REGEX = "\\s*/?\\s*((?:((?=\\d+\\.\\d)\\d+[.\\d]*)|\\d{1,7}(?=(?:\\D|$))))";
    private static final Pattern GECKO_VERSION_PATTERN = Pattern.compile("[ ](?:rv[: ]([0-9\\.]+)).*gecko/", 2);
    private static final Map<String, String> browsersMapping = ConfigUtils.fetchMapFromFile("/configs/availableBrowsers.txt");
    private static final Map<String, String> browsersFamilies = ConfigUtils.fetchMapFromFile("/configs/browserFamilies.txt");
    private final List<Browser> browsers = this.streamToList();
    private final BrowserEngineParser browserEngineParser;

    public BrowserParser(BrowserEngineParser browserEngineParser) {
        Preconditions.checkNotNull((Object)browserEngineParser, (Object)"Browser engine parser cannot be null.");
        this.browserEngineParser = browserEngineParser;
    }

    @Override
    public Map<String, String> parse(String userAgent) {
        return this.browsers.stream().map(browser -> new Tuple<Browser>((Browser)browser, browser.getPattern().matcher(userAgent))).filter(t -> t.getMatcher().find()).findFirst().map(t -> {
            Optional<String> name = this.buildByMatcher(t.getMatcher(), ((Browser)t.get()).getName());
            Optional<String> version = this.buildVersion(t.getMatcher(), ((Browser)t.get()).getVersion());
            Optional<String> engine = this.buildEngine((Browser)t.get(), userAgent, version.orElse(""));
            Optional<String> engineVersion = engine.isPresent() ? BrowserParser.getEngineVersion(engine.get(), userAgent) : Optional.empty();
            return this.toMap(name, version, engine, engineVersion);
        }).orElse(Maps.newHashMap());
    }

    @Override
    public Browser toObject(Object rawObject) {
        Map map = (Map)rawObject;
        HashMap engineMap = Maps.newHashMap();
        if (map.containsKey("engine")) {
            Map engMap = (Map)map.get("engine");
            if (engMap.containsKey("default")) {
                engineMap.put("default", String.valueOf(engMap.get("default")));
            }
            if (engMap.containsKey("versions")) {
                Map versionMap = (Map)engMap.get("versions");
                Iterator iterator = versionMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry obj;
                    Map.Entry entry = obj = iterator.next();
                    engineMap.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
            }
        }
        return new Browser.Builder().withName(String.valueOf(map.get("name"))).withRawRegex((String)map.get("regex")).withVersion(String.valueOf(map.get("version"))).withEngine(engineMap).build();
    }

    @Override
    public String getFilePath() {
        return "/regexes/client/browsers.yml";
    }

    private Optional<String> buildEngine(Browser browser, String userAgent, String stringVersion) {
        Map<String, String> result;
        AtomicReference<String> engine = new AtomicReference<String>(browser.getEngines().getOrDefault("default", ""));
        if (StringUtils.isNotBlank((CharSequence)stringVersion)) {
            DefaultArtifactVersion defaultVersion = new DefaultArtifactVersion(stringVersion);
            AtomicReference<DefaultArtifactVersion> versionToReturn = new AtomicReference<DefaultArtifactVersion>(new DefaultArtifactVersion("0"));
            browser.getEngines().forEach((key, value) -> {
                DefaultArtifactVersion version;
                if (!key.equals("default") && defaultVersion.compareTo((ArtifactVersion)(version = new DefaultArtifactVersion(key))) >= 0 && version.compareTo((ArtifactVersion)versionToReturn.get()) >= 0) {
                    engine.set((String)value);
                    versionToReturn.set(new DefaultArtifactVersion(key));
                }
            });
        }
        if (StringUtils.isEmpty((CharSequence)engine.get()) && (result = this.browserEngineParser.parse(userAgent)).containsKey("engineName")) {
            engine.set(result.get("engineName"));
        }
        return Optional.of(engine.get());
    }

    private static Optional<String> getEngineVersion(String engine, String userAgent) {
        if (engine.equals(GECKO_ENGINE)) {
            Matcher matcher = GECKO_VERSION_PATTERN.matcher(userAgent);
            if (matcher.find()) {
                return Optional.of(matcher.group(1));
            }
            return Optional.empty();
        }
        Pattern pattern = Pattern.compile(engine + ENGINE_VERSION_REGEX, 2);
        Matcher matcher = pattern.matcher(userAgent);
        if (matcher.find()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    private Map<String, String> toMap(Optional<String> name, Optional<String> version, Optional<String> engine, Optional<String> engineVersion) {
        HashMap map = Maps.newHashMap();
        map.put("deviceType", "browser");
        name.ifPresent(val -> map.put("name", val));
        version.ifPresent(val -> map.put("version", val));
        engine.ifPresent(val -> map.put("engine", val));
        engineVersion.ifPresent(val -> map.put("engineVersion", val));
        if (name.isPresent() && browsersMapping.containsKey(name.get())) {
            map.put("shortName", browsersMapping.get(name.get()));
            if (browsersFamilies.containsKey(browsersMapping.get(name.get()))) {
                map.put("browserFamily", browsersFamilies.getOrDefault(browsersMapping.get(name.get()), ""));
            } else {
                map.put("browserFamily", "Unknown");
            }
        }
        return map;
    }
}

