/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.client;

import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.engine.utils.Tuple;
import com.deevvi.device.detector.model.client.Client;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

abstract class ClientParser
implements Parser {
    ClientParser() {
    }

    @Override
    public Map<String, String> parse(String userAgent) {
        return this.getClients().stream().map(client -> new Tuple<Client>((Client)client, client.getPattern().matcher(userAgent))).filter(t -> t.getMatcher().find()).findFirst().map(t -> this.toMap(this.buildByMatcher(t.getMatcher(), ((Client)t.get()).getName()), this.buildVersion(t.getMatcher(), ((Client)t.get()).getVersion()))).orElse(Maps.newHashMap());
    }

    abstract List<? extends Client> getClients();

    abstract String getMediaType();

    private Map<String, String> toMap(Optional<String> name, Optional<String> version) {
        HashMap map = Maps.newHashMap();
        map.put("deviceType", this.getMediaType());
        name.ifPresent(val -> map.put("name", val));
        version.ifPresent(val -> map.put("version", val));
        return map;
    }
}

