/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.client;

import com.deevvi.device.detector.engine.loader.ListLoader;
import com.deevvi.device.detector.engine.parser.client.ClientParser;
import com.deevvi.device.detector.model.client.Client;
import com.deevvi.device.detector.model.client.PIMDevice;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class PIMDeviceParser
extends ClientParser
implements ListLoader<PIMDevice> {
    public static final String PIM = "pim";
    private final List<PIMDevice> pimDevices = this.streamToList();

    @Override
    public List<? extends Client> getClients() {
        return this.pimDevices;
    }

    @Override
    public String getMediaType() {
        return PIM;
    }

    @Override
    public PIMDevice toObject(Object rawObject) {
        Map map = (Map)rawObject;
        return new PIMDevice.Builder().withName((String)map.get("name")).withRawRegex((String)map.get("regex")).withVersion((String)map.get("version")).build();
    }

    @Override
    public Map<String, String> parse(String userAgent) {
        List<String> list = this.getClients().stream().map(Client::getRawRegex).collect(Collectors.toList());
        if (!this.preMatchOverall(list, userAgent)) {
            return Maps.newHashMap();
        }
        return super.parse(userAgent);
    }

    @Override
    public String getFilePath() {
        return "/regexes/client/pims.yml";
    }
}

