/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.device;

import com.deevvi.device.detector.engine.loader.MapLoader;
import com.deevvi.device.detector.engine.parser.device.DeviceParser;
import com.deevvi.device.detector.engine.parser.device.DeviceType;
import com.deevvi.device.detector.model.Model;
import com.deevvi.device.detector.model.device.Camera;
import com.deevvi.device.detector.model.device.Device;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class CameraParser
extends DeviceParser
implements MapLoader<Camera> {
    private final List<Camera> cameras = this.streamToList();

    @Override
    public Camera toObject(String key, Object value) {
        Map map = (Map)value;
        ArrayList models = Lists.newArrayList();
        if (map.containsKey("models")) {
            ((List)map.get("models")).forEach(obj -> {
                Map modelEntry = (Map)obj;
                models.add(new Model((String)modelEntry.get("regex"), (String)modelEntry.get("model")));
            });
        }
        return new Camera.Builder().withDevice((String)map.get("device")).withRawRegex((String)map.get("regex")).withModel(map.getOrDefault("model", "")).withBrand(key).withModels(models).build();
    }

    @Override
    public String getFilePath() {
        return "/regexes/device/cameras.yml";
    }

    @Override
    protected List<? extends Device> getDevices() {
        return this.cameras;
    }

    @Override
    protected String getDeviceType() {
        return DeviceType.CAMERA.getDeviceName();
    }
}

