/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.device;

import com.deevvi.device.detector.engine.loader.MapLoader;
import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.engine.parser.device.DeviceType;
import com.deevvi.device.detector.model.Model;
import com.deevvi.device.detector.model.device.Car;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public final class CarParser
implements Parser,
MapLoader<Car> {
    private final List<Car> cars = this.streamToList();

    @Override
    public Map<String, String> parse(String userAgent) {
        return this.cars.stream().filter(car -> car.getPattern().matcher(userAgent).find()).findFirst().map(car -> this.toMap(this.buildModel((Car)car, userAgent), car.getBrand())).orElse(Maps.newHashMap());
    }

    @Override
    public Car toObject(String key, Object value) {
        Map map = (Map)value;
        ArrayList models = Lists.newArrayList();
        if (map.containsKey("models")) {
            ((List)map.get("models")).forEach(obj -> {
                Map modelEntry = (Map)obj;
                models.add(new Model((String)modelEntry.get("regex"), (String)modelEntry.get("model")));
            });
        }
        return new Car.Builder().withDevice((String)map.get("device")).withRegex((String)map.get("regex")).withBrand(key).withModels(models).build();
    }

    @Override
    public String getFilePath() {
        return "/regexes/device/cars.yml";
    }

    private Optional<String> buildModel(Car car, String userAgent) {
        for (Model model : car.getModels()) {
            Matcher modelMatcher = model.getPattern().matcher(userAgent);
            if (!modelMatcher.find()) continue;
            return Optional.of(model.getModel());
        }
        return Optional.empty();
    }

    private Map<String, String> toMap(Optional<String> model, String brand) {
        HashMap map = Maps.newHashMap();
        map.put("deviceType", DeviceType.CAR_BROWSER.getDeviceName());
        model.ifPresent(val -> map.put("model", val));
        if (StringUtils.isNotEmpty((CharSequence)brand)) {
            map.put("brand", brand);
        }
        return map;
    }
}

