/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.device;

import com.deevvi.device.detector.engine.loader.MapLoader;
import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.engine.parser.device.DeviceParser;
import com.deevvi.device.detector.engine.parser.device.DeviceType;
import com.deevvi.device.detector.model.Model;
import com.deevvi.device.detector.model.device.Console;
import com.deevvi.device.detector.model.device.Device;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ConsoleParser
extends DeviceParser
implements Parser,
MapLoader<Console> {
    private final List<Console> consoles = this.streamToList();

    @Override
    protected List<? extends Device> getDevices() {
        return this.consoles;
    }

    @Override
    protected String getDeviceType() {
        return DeviceType.CONSOLE.getDeviceName();
    }

    @Override
    public Console toObject(String key, Object value) {
        Map map = (Map)value;
        ArrayList models = Lists.newArrayList();
        if (map.containsKey("models")) {
            ((List)map.get("models")).forEach(obj -> {
                Map modelEntry = (Map)obj;
                models.add(new Model((String)modelEntry.get("regex"), (String)modelEntry.get("model")));
            });
        }
        return new Console.Builder().withDevice((String)map.get("device")).withRawRegex((String)map.get("regex")).withModel(map.getOrDefault("model", "")).withBrand(key).withModels(models).build();
    }

    @Override
    public String getFilePath() {
        return "/regexes/device/consoles.yml";
    }
}

