/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.device;

import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.model.Model;
import com.deevvi.device.detector.model.device.Device;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

abstract class DeviceParser
implements Parser {
    DeviceParser() {
    }

    @Override
    public Map<String, String> parse(String userAgent) {
        for (Device device : this.getDevices()) {
            Matcher matcher = device.getPattern().matcher(userAgent);
            if (matcher.find()) {
                return this.toMap(this.buildModel(matcher, device, userAgent), Optional.ofNullable(device.getBrand()));
            }
            if (device.getModels().isEmpty()) continue;
            for (Model model : device.getModels()) {
                Matcher modelMatcher = model.getPattern().matcher(userAgent);
                if (!modelMatcher.find()) continue;
                return this.toMap(Optional.of(model.getModel()), Optional.ofNullable(device.getBrand()));
            }
        }
        return Maps.newHashMap();
    }

    protected abstract List<? extends Device> getDevices();

    protected abstract String getDeviceType();

    private Optional<String> buildModel(Matcher matcher, Device device, String userAgent) {
        if (StringUtils.isNotBlank((CharSequence)device.getModel())) {
            return this.buildModelWithPattern(matcher, device.getModel());
        }
        return this.buildFromModels(device, userAgent);
    }

    private Optional<String> buildFromModels(Device device, String userAgent) {
        for (Model model : device.getModels()) {
            Matcher modelMatcher = model.getPattern().matcher(userAgent);
            if (!modelMatcher.find()) continue;
            return this.buildModelWithPattern(modelMatcher, model.getModel());
        }
        return Optional.empty();
    }

    private Map<String, String> toMap(Optional<String> model, Optional<String> brand) {
        HashMap map = Maps.newHashMap();
        map.put("deviceType", this.getDeviceType());
        model.ifPresent(val -> map.put("model", val));
        brand.ifPresent(val -> map.put("brand", val));
        return map;
    }
}

