/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.device;

import com.deevvi.device.detector.engine.loader.MapLoader;
import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.engine.utils.Tuple;
import com.deevvi.device.detector.model.device.DeviceInfo;
import com.deevvi.device.detector.model.device.Mobile;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public final class MobileParser
implements Parser,
MapLoader<Mobile> {
    private final List<Mobile> mobiles = this.streamToList();

    @Override
    public Map<String, String> parse(String userAgent) {
        return this.mobiles.stream().map(mobile -> new Tuple<Mobile>((Mobile)mobile, mobile.getPattern().matcher(userAgent))).filter(t -> t.getMatcher().find()).findFirst().map(t -> this.buildResult(userAgent, (Tuple<Mobile>)t)).orElse(Maps.newHashMap());
    }

    @Override
    public String getFilePath() {
        return "/regexes/device/mobiles.yml";
    }

    @Override
    public Mobile toObject(String key, Object value) {
        Map map = (Map)value;
        String regex = (String)map.get("regex");
        String device = (String)map.get("device");
        String model = "";
        if (map.containsKey("model")) {
            model = (String)map.get("model");
        }
        ArrayList models = Lists.newArrayList();
        if (map.containsKey("models")) {
            ((List)map.get("models")).forEach(obj -> {
                Map modelMap = (Map)obj;
                String specificModel = null;
                if (modelMap.containsKey("model")) {
                    specificModel = (String)modelMap.get("model");
                }
                String specificBrand = null;
                if (modelMap.containsKey("brand")) {
                    specificBrand = (String)modelMap.get("brand");
                }
                String specificDevice = null;
                if (modelMap.containsKey("device")) {
                    specificDevice = (String)modelMap.get("device");
                }
                models.add(new Mobile.Model((String)modelMap.get("regex"), specificDevice, specificModel, specificBrand));
            });
        }
        return new Mobile.Builder().withDevice(device).withRawRegex(regex).withModel(model).withBrand(key).withModels(models).build();
    }

    private Optional<String> buildModel(String model, Matcher matcher) {
        try {
            return this.buildByMatcher(matcher, model).map(val -> Parser.clear(val).trim());
        }
        catch (IndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }

    private Optional<DeviceInfo> fetchInfo(Mobile mobile, String userAgent) {
        if (this.hasNoModels(mobile)) {
            return Optional.empty();
        }
        for (Mobile.Model entry : mobile.getModels()) {
            Matcher modelMatcher = entry.getRegex().matcher(userAgent);
            if (!modelMatcher.find()) continue;
            String localModel = mobile.getModel();
            if (entry.getModel() != null) {
                localModel = entry.getModel();
            }
            String localBrand = mobile.getBrand();
            if (entry.getBrand() != null) {
                localBrand = entry.getBrand();
            }
            String localDevice = mobile.getDevice();
            if (entry.getDevice() != null) {
                localDevice = entry.getDevice();
            }
            return Optional.of(this.buildDeviceInfo(modelMatcher, localModel, localBrand, localDevice));
        }
        return Optional.of(new DeviceInfo(mobile.getBrand(), mobile.getDevice(), ""));
    }

    private boolean hasNoModels(Mobile mobile) {
        return mobile.getModels() == null || mobile.getModels().isEmpty();
    }

    private DeviceInfo buildDeviceInfo(Matcher matcher, String model, String brand, String device) {
        int index = this.getStartIndex(model);
        if (index == 0) {
            return new DeviceInfo(brand, device, model);
        }
        String group = "$";
        while (model.contains(group + index)) {
            String current = matcher.group(index);
            model = current == null ? model.replace("$" + index, "") : model.replace("$" + index, current);
            ++index;
        }
        return new DeviceInfo(brand, device, model);
    }

    private Map<String, String> buildResult(String userAgent, Tuple<Mobile> t) {
        AtomicReference<String> model = new AtomicReference<String>();
        AtomicReference<String> brand = new AtomicReference<String>();
        AtomicReference<String> deviceType = new AtomicReference<String>();
        Optional<DeviceInfo> deviceInfo = this.fetchInfo(t.get(), userAgent);
        if (deviceInfo.isPresent()) {
            DeviceInfo info = deviceInfo.get();
            model.set(info.getModel());
            brand.set(info.getBrand());
            deviceType.set(info.getDevice());
        } else {
            deviceType.set(t.get().getDevice());
            brand.set(t.get().getBrand());
            if (((String)brand.get()).equalsIgnoreCase("Unknown")) {
                brand.set("");
            }
            model.set(this.buildModel(t.get().getModel(), t.getMatcher()).orElse(""));
        }
        return this.encodeResponse((String)deviceType.get(), (String)model.get(), (String)brand.get());
    }

    private Map<String, String> encodeResponse(String deviceType, String model, String brand) {
        if (Parser.checkContainsPlaceholder(deviceType) || Parser.checkContainsPlaceholder(model) || Parser.checkContainsPlaceholder(brand)) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        map.put("deviceType", StringUtils.trimToEmpty((String)deviceType));
        map.put("model", StringUtils.trimToEmpty((String)model));
        map.put("brand", StringUtils.trimToEmpty((String)brand));
        return map;
    }
}

