/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.device;

import com.deevvi.device.detector.engine.loader.MapLoader;
import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.engine.parser.device.DeviceParser;
import com.deevvi.device.detector.engine.parser.device.DeviceType;
import com.deevvi.device.detector.model.Model;
import com.deevvi.device.detector.model.device.Device;
import com.deevvi.device.detector.model.device.Notebook;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class NotebookParser
extends DeviceParser
implements Parser,
MapLoader<Notebook> {
    private final List<Notebook> notebooks = this.streamToList();

    @Override
    protected List<? extends Device> getDevices() {
        return this.notebooks;
    }

    @Override
    protected String getDeviceType() {
        return DeviceType.DESKTOP.getDeviceName();
    }

    @Override
    public Notebook toObject(String key, Object value) {
        Map map = (Map)value;
        ArrayList models = Lists.newArrayList();
        if (map.containsKey("models")) {
            ((List)map.get("models")).forEach(obj -> {
                Map modelEntry = (Map)obj;
                models.add(new Model((String)modelEntry.get("regex"), (String)modelEntry.get("model")));
            });
        }
        return new Notebook.Builder().withDevice((String)map.get("device")).withBrand(key).withRawRegex((String)map.get("regex")).withModel(map.getOrDefault("model", "")).withModels(models).build();
    }

    @Override
    public String getFilePath() {
        return "/regexes/device/notebooks.yml";
    }
}

