/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.device;

import com.deevvi.device.detector.engine.loader.MapLoader;
import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.engine.parser.device.DeviceParser;
import com.deevvi.device.detector.engine.parser.device.DeviceType;
import com.deevvi.device.detector.model.Model;
import com.deevvi.device.detector.model.device.BasicDevice;
import com.deevvi.device.detector.model.device.Device;
import com.deevvi.device.detector.model.device.PortableMediaPlayer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class PortableMediaPlayerParser
extends DeviceParser
implements Parser,
MapLoader<PortableMediaPlayer> {
    private final List<PortableMediaPlayer> mediaPlayers = this.streamToList();

    @Override
    protected List<? extends Device> getDevices() {
        return this.mediaPlayers;
    }

    @Override
    protected String getDeviceType() {
        return DeviceType.PORTABLE_MEDIA_PLAYER.getDeviceName();
    }

    @Override
    public Map<String, String> parse(String userAgent) {
        List<String> regexes = this.getDevices().stream().map(BasicDevice::getRawRegex).collect(Collectors.toList());
        if (this.preMatchOverall(regexes, userAgent)) {
            return super.parse(userAgent);
        }
        return Maps.newHashMap();
    }

    @Override
    public PortableMediaPlayer toObject(String key, Object value) {
        Map map = (Map)value;
        ArrayList models = Lists.newArrayList();
        if (map.containsKey("models")) {
            ((List)map.get("models")).forEach(obj -> {
                Map modelEntry = (Map)obj;
                models.add(new Model((String)modelEntry.get("regex"), (String)modelEntry.get("model")));
            });
        }
        return new PortableMediaPlayer.Builder().withDevice((String)map.get("device")).withRawRegex((String)map.get("regex")).withModel(map.getOrDefault("model", "")).withBrand(key).withModels(models).build();
    }

    @Override
    public String getFilePath() {
        return "/regexes/device/portable_media_player.yml";
    }
}

