/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.device;

import com.deevvi.device.detector.engine.loader.MapLoader;
import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.engine.parser.device.DeviceType;
import com.deevvi.device.detector.model.device.ShellTv;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class ShellTvParser
implements Parser,
MapLoader<ShellTv> {
    private final Pattern SHELL_TV_PATTERN = Pattern.compile("[a-z]+[ _]Shell[ _]\\w{6}", 2);
    private final List<ShellTv> shellTvs = this.streamToList();

    @Override
    public ShellTv toObject(String key, Object value) {
        Map map = (Map)value;
        return new ShellTv.Builder().withDevice((String)map.get("device")).withBrand(key).withRawRegex((String)map.get("regex")).withModel(map.getOrDefault("model", "")).build();
    }

    @Override
    public String getFilePath() {
        return "/regexes/device/shell_tv.yml";
    }

    @Override
    public Map<String, String> parse(String userAgent) {
        if (!this.isShellTV(userAgent)) {
            return Maps.newHashMap();
        }
        return this.shellTvs.stream().filter(shellTv -> shellTv.getPattern().matcher(userAgent).find()).findFirst().map(shellTv -> this.toMap(shellTv.getBrand(), shellTv.getModel())).orElse((Map)new ImmutableMap.Builder().put((Object)"deviceType", (Object)DeviceType.TV.getDeviceName()).build());
    }

    private boolean isShellTV(String userAgent) {
        return this.SHELL_TV_PATTERN.matcher(userAgent).find();
    }

    private Map<String, String> toMap(String brand, String model) {
        HashMap map = Maps.newHashMap();
        map.put("deviceType", DeviceType.TV.getDeviceName());
        map.put("model", model);
        if (StringUtils.isNotEmpty((CharSequence)brand)) {
            map.put("brand", brand);
        }
        return map;
    }
}

