/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.device;

import com.deevvi.device.detector.engine.loader.MapLoader;
import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.engine.parser.device.DeviceType;
import com.deevvi.device.detector.model.Model;
import com.deevvi.device.detector.model.device.Television;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class TelevisionParser
implements Parser,
MapLoader<Television> {
    private static final Pattern HBB_TV_PATTERN = Pattern.compile("(?:^|[^A-Z0-9\\-_]|[^A-Z0-9\\-]_|sprd-)(?:HbbTV/([1-9]{1}(?:\\.[0-9]{1}){1,2}))".replaceAll("/", "\\\\/"), 2);
    private final List<Television> televisions = this.streamToList();

    @Override
    public Map<String, String> parse(String userAgent) {
        Matcher hbbMatcher = HBB_TV_PATTERN.matcher(userAgent);
        if (!hbbMatcher.find()) {
            return Maps.newHashMap();
        }
        for (Television television : this.televisions) {
            Matcher matcher = television.getPattern().matcher(userAgent);
            if (!matcher.find()) continue;
            return this.toMap(television.getBrand(), this.buildModel(matcher, television, userAgent));
        }
        for (Television television : this.televisions) {
            if (television.getModels().isEmpty()) continue;
            for (Model model : television.getModels()) {
                Matcher modelMatcher = model.getPattern().matcher(userAgent);
                if (!modelMatcher.find()) continue;
                return this.toMap(television.getBrand(), Optional.of(model.getModel()));
            }
        }
        Matcher matcher = HBB_TV_PATTERN.matcher(userAgent);
        HashMap map = Maps.newHashMap();
        if (matcher.find()) {
            map.put("deviceType", DeviceType.TV.getDeviceName());
            if (matcher.groupCount() >= 1) {
                map.put("version", matcher.group(1));
            }
        }
        return map;
    }

    @Override
    public Television toObject(String key, Object value) {
        Map map = (Map)value;
        ArrayList models = Lists.newArrayList();
        if (map.containsKey("models")) {
            ((List)map.get("models")).forEach(obj -> {
                Map modelEntry = (Map)obj;
                models.add(new Model((String)modelEntry.get("regex"), (String)modelEntry.get("model")));
            });
        }
        return new Television.Builder().withDevice((String)map.get("device")).withRawRegex((String)map.get("regex")).withModel(map.getOrDefault("model", "")).withBrand(key).withModels(models).build();
    }

    @Override
    public String getFilePath() {
        return "/regexes/device/televisions.yml";
    }

    private Optional<String> buildModel(Matcher matcher, Television television, String userAgent) {
        if (StringUtils.isNotBlank((CharSequence)television.getModel())) {
            return this.buildModelWithPattern(matcher, television.getModel());
        }
        if (!television.getModels().isEmpty()) {
            for (Model model : television.getModels()) {
                Matcher modelMatcher = model.getPattern().matcher(userAgent);
                if (!modelMatcher.find()) continue;
                return this.buildModelWithPattern(modelMatcher, model.getModel());
            }
        }
        return Optional.empty();
    }

    private Map<String, String> toMap(String brand, Optional<String> model) {
        HashMap map = Maps.newHashMap();
        map.put("deviceType", DeviceType.TV.getDeviceName());
        model.ifPresent(val -> map.put("model", val));
        if (StringUtils.isNotEmpty((CharSequence)brand)) {
            map.put("brand", brand);
        }
        return map;
    }
}

