/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.parser.facade;

import com.deevvi.device.detector.engine.parser.Parser;
import com.deevvi.device.detector.engine.parser.facade.ParserPair;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ParserFacade
implements Parser {
    private final List<ParserPair> parsers;
    private final ExecutorService service;

    public ParserFacade(List<ParserPair> parsers) {
        Preconditions.checkArgument((parsers != null && !parsers.isEmpty() ? 1 : 0) != 0, (Object)"List of client parsers cannot be empty.");
        this.parsers = parsers;
        this.service = Executors.newFixedThreadPool(parsers.size());
    }

    @Override
    public Map<String, String> parse(String userAgent) {
        ArrayList futures = Lists.newArrayList();
        this.parsers.forEach(parser -> futures.add(this.service.submit(() -> new ParserResult(parser.getOrder(), parser.getParser().parse(userAgent)))));
        AtomicBoolean done = new AtomicBoolean(false);
        AtomicReference<HashMap> result = new AtomicReference<HashMap>(Maps.newHashMap());
        AtomicInteger minPosition = new AtomicInteger(Integer.MAX_VALUE);
        while (!done.get()) {
            done.set(true);
            futures.forEach(future -> {
                if (future.isDone()) {
                    try {
                        this.processFuture((Future<ParserResult>)future, (AtomicReference<Map<String, String>>)result, minPosition);
                    }
                    catch (Exception exception) {}
                } else {
                    done.set(false);
                }
            });
            Thread.yield();
        }
        return result.get();
    }

    private void processFuture(Future<ParserResult> future, AtomicReference<Map<String, String>> result, AtomicInteger minPosition) throws Exception {
        ParserResult parserResult = future.get();
        if (!parserResult.getResult().isEmpty()) {
            if (parserResult.getOrder() < minPosition.get()) {
                minPosition.set(parserResult.getOrder());
                result.set(parserResult.getResult());
            } else if (result.get().containsKey("deviceType") && result.get().get("deviceType").equals(parserResult.getResult().get("deviceType"))) {
                result.set(this.processResult(result.get(), parserResult));
            }
        }
    }

    private Map<String, String> processResult(Map<String, String> result, ParserResult parserResult) {
        HashMap map = Maps.newHashMap(result);
        if (parserResult.getResult().size() > result.size()) {
            return parserResult.getResult();
        }
        if (Parser.checkContainsPlaceholder(map.getOrDefault("model", "")) && !Parser.checkContainsPlaceholder(parserResult.getResult().getOrDefault("model", ""))) {
            map.put("model", parserResult.getResult().get("model"));
        }
        return map;
    }

    private static class ParserResult {
        private final int order;
        private final Map<String, String> result;

        public ParserResult(int order, Map<String, String> result) {
            this.order = order;
            this.result = result;
        }

        public int getOrder() {
            return this.order;
        }

        public Map<String, String> getResult() {
            return this.result;
        }
    }
}

