/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.engine.utils;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUtils.class);

    private ConfigUtils() {
    }

    public static List<String> fetchListFromFile(String filePath) {
        try {
            return ImmutableList.copyOf(ConfigUtils.readFileContent(filePath));
        }
        catch (IOException e) {
            LOG.error("Unable to read config from file {}", (Object)filePath, (Object)e);
            System.exit(1);
            return Lists.newArrayList();
        }
    }

    public static Map<String, String> fetchMapFromFile(String filePath) {
        try {
            HashMap map = Maps.newHashMap();
            ConfigUtils.readFileContent(filePath).forEach(line -> {
                List splits = Splitter.on((String)"=").splitToList((CharSequence)line);
                if (splits.size() == 2) {
                    map.put(splits.get(0), splits.get(1));
                }
            });
            return Collections.unmodifiableMap(map);
        }
        catch (IOException e) {
            LOG.error("Unable to read config from file {}", (Object)filePath, (Object)e);
            System.exit(1);
            return Maps.newHashMap();
        }
    }

    private static List<String> readFileContent(String filePath) throws IOException {
        return Splitter.on((String)"\n").splitToList((CharSequence)IOUtils.resourceToString((String)filePath, (Charset)Charsets.UTF_8));
    }
}

