/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.model;

import com.deevvi.device.detector.model.PatternBuilder;
import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class Bot
implements PatternBuilder {
    private final Pattern pattern;
    private final String name;
    private final String category;
    private final String url;
    private final String producerName;
    private final String producerUrl;

    private Bot(String rawRegex, String name, String category, String url, String producerName, String producerUrl) {
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)rawRegex), (Object)"Raw regex cannot be null or empty.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)name), (Object)"Operating system name cannot be null or empty.");
        this.pattern = this.toPattern(rawRegex);
        this.name = name;
        this.category = category;
        this.url = url;
        this.producerName = producerName;
        this.producerUrl = producerUrl;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getUrl() {
        return this.url;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public String getProducerUrl() {
        return this.producerUrl;
    }

    public static class Builder {
        private String rawRegex;
        private String name;
        private String category;
        private String url;
        private String producerName;
        private String producerUrl;

        public Builder withRawRegex(String rawRegex) {
            this.rawRegex = rawRegex;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withProducerName(String producerName) {
            this.producerName = producerName;
            return this;
        }

        public Builder withProducerUrl(String producerUrl) {
            this.producerUrl = producerUrl;
            return this;
        }

        public Bot build() {
            return new Bot(this.rawRegex, this.name, this.category, this.url, this.producerName, this.producerUrl);
        }
    }
}

