/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.model;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class OperatingSystem {
    private final Pattern pattern;
    private final String name;
    private final String version;
    private final Map<Pattern, String> versions;

    private OperatingSystem(Pattern pattern, String name, String version, Map<Pattern, String> versions) {
        Preconditions.checkNotNull((Object)pattern, (Object)"Regex pattern cannot be null or empty.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)name), (Object)"Operating system name cannot be null or empty.");
        this.pattern = pattern;
        this.name = name;
        this.version = version;
        this.versions = versions;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<Pattern, String> getVersions() {
        return this.versions;
    }

    public static class Builder {
        private Pattern pattern;
        private String name;
        private String version;
        private Map<Pattern, String> versions;

        public Builder withPattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withVersions(Map<Pattern, String> versions) {
            this.versions = versions;
            return this;
        }

        public OperatingSystem build() {
            return new OperatingSystem(this.pattern, this.name, this.version, this.versions);
        }
    }
}

