/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.model;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class VendorFragments {
    private final String vendor;
    private final List<Pattern> patterns;

    private VendorFragments(String vendor, List<Pattern> patterns) {
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)vendor), (Object)"Vendor cannot be null or empty.");
        Preconditions.checkNotNull(patterns, (Object)"Pattern list cannot be null.");
        this.vendor = vendor;
        this.patterns = patterns;
    }

    public String getVendor() {
        return this.vendor;
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    public static class Builder {
        private String vendor;
        private List<Pattern> patterns;

        public Builder withVendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder withPatterns(List<Pattern> patterns) {
            this.patterns = patterns;
            return this;
        }

        public VendorFragments build() {
            return new VendorFragments(this.vendor, this.patterns);
        }
    }
}

