/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.model.client;

import com.deevvi.device.detector.model.client.Client;
import com.google.common.base.Preconditions;
import java.util.Map;

public final class Browser
extends Client {
    private final Map<String, String> engines;

    private Browser(String name, String rawRegex, String version, Map<String, String> engines) {
        super(name, rawRegex, version);
        Preconditions.checkNotNull(engines, (Object)"Engines map cannot be null or empty.");
        this.engines = engines;
    }

    public Map<String, String> getEngines() {
        return this.engines;
    }

    public static class Builder {
        private String name;
        private String rawRegex;
        private String version;
        private Map<String, String> engine;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withRawRegex(String rawRegex) {
            this.rawRegex = rawRegex;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withEngine(Map<String, String> engine) {
            this.engine = engine;
            return this;
        }

        public Browser build() {
            return new Browser(this.name, this.rawRegex, this.version, this.engine);
        }
    }
}

