/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.model.client;

import com.deevvi.device.detector.model.PatternBuilder;
import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class BrowserEngine
implements PatternBuilder {
    private final String name;
    private final String rawRegex;
    private final Pattern pattern;

    private BrowserEngine(String name, String rawRegex) {
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)name), (Object)"Name cannot be null or empty.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)rawRegex), (Object)"Raw regex cannot be null or empty.");
        this.name = name;
        this.rawRegex = rawRegex;
        this.pattern = this.toPattern(rawRegex);
    }

    public String getName() {
        return this.name;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getRawRegex() {
        return this.rawRegex;
    }

    public static class Builder {
        private String name;
        private String rawRegex;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withRawRegex(String rawRegex) {
            this.rawRegex = rawRegex;
            return this;
        }

        public BrowserEngine build() {
            return new BrowserEngine(this.name, this.rawRegex);
        }
    }
}

