/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.model.client;

import com.deevvi.device.detector.model.PatternBuilder;
import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Client
implements PatternBuilder {
    private final String name;
    private final String rawRegex;
    private final Pattern pattern;
    private final String version;

    protected Client(String name, String rawRegex, String version) {
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)name), (Object)"Name cannot be null or empty.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)rawRegex), (Object)"Raw regex cannot be null or empty.");
        this.name = name;
        this.rawRegex = rawRegex;
        this.pattern = this.toPattern(rawRegex);
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRawRegex() {
        return this.rawRegex;
    }
}

