/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.model.client;

import com.deevvi.device.detector.model.client.Client;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public final class FeedReader
extends Client {
    private final String url;
    private final String type;

    private FeedReader(String name, String rawRegex, String version, String url, String type) {
        super(name, rawRegex, version);
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)url), (Object)"Feed parser url cannot be null or empty.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)type), (Object)"Feed parser type cannot be null or empty.");
        this.url = url;
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getType() {
        return this.type;
    }

    public static class Builder {
        private String name;
        private String rawRegex;
        private String version;
        private String url;
        private String type;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withRawRegex(String rawRegex) {
            this.rawRegex = rawRegex;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public FeedReader build() {
            return new FeedReader(this.name, this.rawRegex, this.version, this.url, this.type);
        }
    }
}

