/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.model.device;

import com.deevvi.device.detector.model.PatternBuilder;
import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class BasicDevice
implements PatternBuilder {
    private final String rawRegex;
    private final Pattern pattern;
    private final String device;
    private final String brand;

    public BasicDevice(String rawRegex, String device, String brand) {
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)rawRegex), (Object)"Raw regex cannot be null or empty.");
        Preconditions.checkNotNull((Object)StringUtils.trimToNull((String)brand), (Object)"Brand cannot be null or empty.");
        this.rawRegex = rawRegex;
        this.pattern = this.toPattern(rawRegex);
        this.device = device;
        this.brand = brand;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getDevice() {
        return this.device;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getRawRegex() {
        return this.rawRegex;
    }
}

