/*
 * Decompiled with CFR 0.152.
 */
package com.deevvi.device.detector.model.device;

import com.deevvi.device.detector.model.PatternBuilder;
import com.deevvi.device.detector.model.device.BasicDevice;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;

public final class Mobile
extends BasicDevice {
    private final String model;
    private final List<Model> models;

    private Mobile(String rawRegex, String device, String model, String brand, List<Model> models) {
        super(rawRegex, device, brand);
        this.model = model;
        this.models = models;
    }

    public String getModel() {
        return this.model;
    }

    public List<Model> getModels() {
        return this.models;
    }

    public static class Model
    implements PatternBuilder {
        private final Pattern pattern;
        private final String device;
        private final String model;
        private final String brand;

        public Model(String rawRegex, String device, String model, String brand) {
            this.pattern = this.toPattern(rawRegex);
            this.device = device;
            this.model = model;
            this.brand = brand;
        }

        public Pattern getRegex() {
            return this.pattern;
        }

        public String getDevice() {
            return this.device;
        }

        public String getModel() {
            return this.model;
        }

        public String getBrand() {
            return this.brand;
        }
    }

    public static class Builder {
        private String rawRegex;
        private String device;
        private String model;
        private String brand;
        private List<Model> models;

        public Builder withRawRegex(String rawRegex) {
            this.rawRegex = rawRegex;
            return this;
        }

        public Builder withDevice(String device) {
            this.device = device;
            return this;
        }

        public Builder withModel(String model) {
            this.model = model;
            return this;
        }

        public Builder withBrand(String brand) {
            this.brand = brand;
            return this;
        }

        public Builder withModels(Model model) {
            if (this.models == null) {
                this.models = Lists.newArrayList();
            }
            this.models.add(model);
            return this;
        }

        public Builder withModels(List<Model> models) {
            this.models = models;
            return this;
        }

        public Mobile build() {
            return new Mobile(this.rawRegex, this.device, this.model, this.brand, this.models);
        }
    }
}

