<?xml version='1.0' encoding='ISO-8859-1'?>
<!--
    $Id: report2html.xsl 97137 2009-04-22 12:35:43Z neil $
-->
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:resources="xalan://fuego.simulation.report.XSLResources"
    >


    <xsl:output method="html" indent="yes"/>

    <xsl:param name="xsim"/> <!-- the path of the simulation model -->
    <xsl:param name="version"/>
    <xsl:param name="resources-dir"/>
    <xsl:param name="stylesheet">style5.css</xsl:param>

    <!--xsl:dataObject name="xsim-path" select="{$xsim}"/-->
    <!-- ======================================================================================================== -->
    <!-- MAIN TEMPLATES - REPORTS AND NESTED FILE                                                                 -->
    <!-- ======================================================================================================== -->

    <xsl:template match="/report">
        <HTML>
            <HEAD>
                <TITLE>
                </TITLE>
                <LINK REL="stylesheet" TYPE="text/css" HREF="{$resources-dir}/{$stylesheet}" TITLE="Style"/>
            </HEAD>
            <BODY>

                <table border="0" width="100%" cellpadding="0" cellspacing="0">
                    <tr valign="middle" class="header">
                        <td class="navbarbg" align="center" height="45">
                            <img src="{$resources-dir}/5x5.gif" width="180" height="1"/>
                            <br/>
                            <img src="{$resources-dir}/logo.gif"/>
                        </td>
                        <td width="100%" class="header" align="center" colspan="2">
                            <a class="welcome">
                                <xsl:value-of select="/report/@title"/>
                            </a>
                            <img src="{$resources-dir}/5x5.gif" width="10" height="5"/>
                        </td>
                    </tr>
                </table>

                <table width="100%" border="0" cellspacing="1" cellpadding="0">
                    <tr>
                        <td class="banner">
                            <img src="{$resources-dir}/5x5.gif" width="8" height="7"/>
                        </td>
                    </tr>
                </table>


                <xsl:apply-templates select="document($xsim)"/>

                <H1>
                    <xsl:value-of select="resources:get('SIMULATION_RESULTS')"/>
                </H1>
                <xsl:apply-templates/>
            </BODY>
        </HTML>
    </xsl:template>


    <xsl:template match="statistics">
        <H2>
            <xsl:value-of select="resources:get(@type)"/>
        </H2>

        <CENTER>
        <IMG src="{$resources-dir}/{@image}"/>
        <BR />
        <BR />
        <TABLE>
            <TR>
                <TD></TD>
                <xsl:for-each select="indicators/indicator">
                    <TD>
                        <B><xsl:value-of select="resources:get(../../@type, @name)"/></B>
                    </TD>
                </xsl:for-each>
            </TR>

            <xsl:apply-templates>
                <xsl:with-param name="level" select="number(0)"/>
            </xsl:apply-templates>
        </TABLE>
        </CENTER>

    </xsl:template>


    <xsl:template match="activity">
        <xsl:param name="level"/>
        <TR>
            <TD>
                <xsl:call-template name="indent">
                    <xsl:with-param name="max" select="$level"/>
                </xsl:call-template>

                <B><xsl:value-of select="@name"/></B>
            </TD>
            <xsl:for-each select="indicator">
                <TD>
                    <xsl:value-of select="@value"/>
                </TD>
            </xsl:for-each>

            <xsl:apply-templates>
                <xsl:with-param name="level" select="$level + 1"/>
            </xsl:apply-templates>
        </TR>
    </xsl:template>

    <xsl:template name="indent">
        <xsl:param name="current" select="number(0)"/>
        <xsl:param name="max"/>

        <xsl:if test="$current &lt;= $max">
            &nbsp;&nbsp;
            <xsl:call-template name="indent">
                <xsl:with-param name="current" select="$current + 1"/>
                <xsl:with-param name="max" select="$max"/>
           </xsl:call-template>
        </xsl:if>
    </xsl:template>


    <xsl:template match="SimulationModel">
        <H1>
            <xsl:value-of select="resources:get('SIMULATION_MODEL')"/>
        </H1>

        <TABLE>
            <TR>
                <TD>
                    <xsl:value-of select="resources:get('START_TIME')"/>:
                </TD>
                <TD>
                    <xsl:value-of select="resources:formatTime(@startTime)"/>
                </TD>
            </TR>
            <TR>
                <TD>
                    <xsl:value-of select="resources:get('DURATION')"/>:
                </TD>
                <TD>
                    <xsl:value-of select="resources:formatInterval(@duration)"/>
                </TD>
            </TR>
            <TR>
                <TD>
                    <xsl:value-of select="resources:get('NUMBER_OF_INSTANCES')"/>:
                </TD>
                <TD>
                    <xsl:value-of select="@maxInstances"/>
                </TD>
            </TR>
        </TABLE>
        <TABLE>
            <TR>
                <TD></TD>
                <TD>
                    <B><xsl:value-of select="resources:getEnum('ACTIVITY_QUEUE_POLICY')"/></B>
                </TD>
                <TD>
                    <B><xsl:value-of select="resources:getEnum('ACTIVITY_COST_TYPE')"/></B>
                </TD>
                <TD>
                    <B><xsl:value-of select="resources:getEnum('PARTICIPANT_SELECTION_POLICY')"/></B>
                </TD>
                <TD>
                    <B><xsl:value-of select="resources:get('EXCEPTION_PROBABILITY')"/></B>
                </TD>
                <TD>
                    <B><xsl:value-of select="resources:get('ABORT_PROBABILITY')"/></B>
                </TD>
                <TD>
                    <B><xsl:value-of select="resources:get('DUE_TIME')"/></B>
                </TD>
            </TR>
        <xsl:for-each select="Activity">
            <TR>
                <TD>
                    <B><xsl:value-of select="@name"/></B>
                </TD>
                <TD>
                    <xsl:value-of select="resources:get('ACTIVITY_QUEUE_POLICY', @queuePolicy)"/>
                </TD>

                <TD>
                    <xsl:value-of select="resources:get('ACTIVITY_COST_TYPE', @activityCostType)"/>
                </TD>

                <TD>
                    <xsl:value-of select="resources:get('PARTICIPANT_SELECTION_POLICY', @participantSelectionPolicy)"/>
                </TD>

                <TD>
                    <xsl:value-of select="@exceptionProbability"/>
                </TD>
                <TD>
                    <xsl:value-of select="@abortProbability"/>
                </TD>
                <TD>
                    <xsl:choose>
                        <xsl:when test="@dueTime='0'">
                            <xsl:value-of select="resources:get('N_A')"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="resources:formatInterval(@dueTime)"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </TD>
            </TR>
        </xsl:for-each>
    </TABLE>
</xsl:template>

</xsl:stylesheet>
