<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/TR/REC-html40" version="1.0">
  <xsl:output omit-xml-declaration="yes" method="xml" indent="yes" encoding="UTF-8"/>
  <xsl:template match="/healthchecks">
   
  <html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title><xsl:value-of select="@page_title_hdr"/></title>
<style type="text/css">
#div.main { background-color: #F2F2F7; width=100%; }
div.main { background-color: #FFFFFF; }
div.top { background-color: black; width=100%; color: white; font-size: 22; font-weight: bold; text-align: center; padding-bottom: 10px; margin-bottom: 10px; }

table.summary { padding=4px;  border:2px solid black;}
table.summary tr { padding=2px;  border:2px solid black;}
table.summary td { text-align: left; border: 2px solid black; }
table.summary th { text-align: left; border: 2px solid black; padding-right: 8px; }
table.summary th.title { text-align: center; border: 2px solid black; background-color: #0066CC; }
#div.summary { width: 75%; }

<!--
table.results { border: 2px solid #E4E4E4; width=100%; border-collapse: collapse; }
table.results tr { width: 100%; border-collapse: collapse; padding=2px;  border:2px solid #E4E4E4;}
table.results th { border: none; width=100%; text-align: left; padding-right: 8px; }
table.results td.resultIcon { border: 2px solid #E4E4E4; width=100%; text-align: center; margin-right: 8px; padding-right: 8px }
table.results tr.action { width=100%; border-collapse: collapse; padding=2px;  border:2px solid #E4E4E4; font-size: 1.2em; }

table.issues { width: 100%; border-collapse: collapse; padding=4px;  border:2px solid #E4E4E4;background-color: #FCFCFC;}
table.issues tr { width: 100%; border-collapse: collapse; padding=4px; }
table.issues td { border-collapse: collapse; padding=4px; padding-right: 8px;}
-->

<!--
table.inner { width: 100%; }
table.inner tr { width: 100%; }
-->
table.results { border-collapse: collapse; padding=4px;  border:2px solid black;}
table.results tr { border-collapse: collapse; padding=2px;  border:2px solid black;}
table.results td { text-align: left; border: 2px solid black; white-space: pre-line;}
table.results th { text-align: left; border: 2px solid black; padding-right: 8px; }
table.results th.title { text-align: center; border: 2px solid black; background-color: #0066CC; }

<!--
table.inner { border-collapse: collapse; padding=4px;  border:2px solid #E4E4E4;}
table.inner tr { border-collapse: collapse; padding=2px;  border:2px solid #E4E4E4;}
table.inner td { text-align: left; border: 2px solid #E4E4E4; white-space: pre-line;}
table.inner th { text-align: left; border: 2px solid #E4E4E4; padding-right: 8px; }
table.inner th.title { text-align: center; border: 2px solid #E4E4E4; background-color: #99CCFF; }
-->

img.oracleLogo {
  padding-left:95px;
  padding-right:95px;
  padding-top: 17px;
  padding-right: 17px;
  background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGgAAAAOCAYAAADDsVnmAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA1RJREFUeNrMWN2N2kAQNicKQMprpICU90AFZ1dwpgJMBYEK7qgArgJzFdipAK4CnPdI50h5jbKp4DITzZ4+zS3srp1EGckC27Mzs/P7rYeJg76/fZ8mYdS++faldawf0884CSdDcppQZpI/pR+2sXbp96wbhfCS3CP4Icq+Pv4QvZa/GSoht3QVkcrZ8A0JruFxIbJi5LCjl2yghy+nn0pub+l+5gsS8Vh7QpNmRxfbcZB7/p91CEwueqeBS46glxPJXEFmnWKDI8RrK5JRJv2InXe4VL30jo1GPfretaYUntDgcLA3Pfdi9VYRwTGcoFIoxl5D2fQBSt8a6GsdzH8DQS1I1mfK5p3iW3OpemR9pCu3VSFZ5KIS7DTyPyW9K4dedtJWJR3zfApo26ZncAqldy96jafNt7Keed/R9TiQSFth3NPnHYwpwWkTulbQ4jJf2xI5J5ttxD/wtLZWAl+hXnSsZOITvM9i5wjJeLath9ZmEet+QCJx2953DfYVZO7vEosVIMr3UFVpR1tMRGtbyszbXWh1mMGbPkO+w9yxwdn3CQ7TEITVPUr7ARwy7dgSUqgOTVtlp63IjSQYV0vOzgGw8kG1mH9FuP9C9hZKM51Iw5AM/gNZtRInh9DGAfkLV5VzQtF7bHUl3R8l0UbIl/z/tHNVOQYol77eN2uMPmvwACfHGR/iEiP3ntZmlOya+Gqx3/LPBZiktu2oY8DfpFbB5scIaP+KGCRUMIfWLjTkqY6RDGMblIk6B72ABIHzBxVA1vdT+nXrQGEr2KwBWy+RBTq2shqxw0TuLRokOMDJpE8FM0i4x15PCu7E6SHGpHJ+wqHYXgAU7KiZgt2564uAyF6p1rYMbMVbCWgDFX6I+ELSmWQfCJpOffQOxBl3jpN/43FG6uDPZC7cXYLZkgAVyDCAzCzPExwuXypbNntuw9fwbifgRVesCTiX8ZlkDhUUskaf/UoHYDoGrF1isg4UktqGfqtSVON88AVInbYR5axlXuH6hp7NOrbbTGZCGQn/rR3PHYf9GuZnHrv2VQWpDVrYeh0wDL+emR3s9AVstvEgvBt4dC9fFpKQ9Wcg+wKCu4b5l8sJfez5krCEM80iImmNBjIyk4oAvcYFgn4JMADJYLtVgTm2PgAAAABJRU5ErkJggg==);
  background-repeat: no-repeat;
  background-position: left center;
}


#endOfHeader { 
    padding-bottom: 20px;
    }
    
</style>
</head>
<body>
 
<div class="main">
<!--
      <script type="text/javascript">
<xsl:text>  function toggle_visibility(id) {
       var e = document.getElementById(id);
       if(e.style.display == 'block')
          e.style.display = 'none';
       else
          e.style.display = 'block';

    }</xsl:text>  
</script>
-->
<div class="top">
       <img src="" alt="" class="oracleLogo"/><span><xsl:value-of select="@page_title_hdr"/></span>
</div>
<div class="header">
<table class="header">
	<tr><td scope="row"><xsl:value-of select="page_summary/@page_info_hdr" /> </td><td><xsl:value-of select="page_summary/text()" /> <xsl:value-of select="page_summary/@page_summary_addon_hdr" /> <xsl:value-of select="report_date/text()" /></td></tr>

<!--	<tr><td scope="row">Report Date: </td><td><xsl:value-of select="@report_date" /></td></tr> -->

	<tr><td scope="row"><xsl:value-of select="run_id/@id_hdr" /> </td><td><xsl:value-of select="run_id/text()" /></td></tr>
        <tr><td scope="row"><xsl:value-of select="server_name/@serverName_hdr" /></td><td><xsl:value-of select="server_name/text()" /> <xsl:value-of select="server_name/@serverName_addon_hdr" /> <xsl:value-of select="host_name/text()" /></td></tr>

<!--        <tr><td scope="row">Hostname: </td><td><xsl:value-of select="@hostName" /></td></tr> -->

        <tr><td scope="row"><xsl:value-of select="cmd_name/@cmdname_hdr" /> </td><td><xsl:value-of select="cmd_name/text()" /></td></tr>
        <tr><td scope="row"><xsl:value-of select="start_time/@time_hdr" /> </td><td><xsl:value-of select="start_time/@time_addon1_hdr" /> <xsl:value-of select="start_time/text()" /> <xsl:value-of select="start_time/@time_addon2_hdr" /> <xsl:value-of select="end_time/text()" /></td></tr>
<!--
        <tr><td scope="row">Start_Time: </td><td><xsl:value-of select="@start_time" /></td></tr>
        <tr><td scope="row">End_Time: </td><td><xsl:value-of select="@end_time" /></td></tr>
        <tr><td scope="row">Duration: </td><td><xsl:value-of select="@duration" /></td></tr>
-->
</table>
</div>
<br/>
<br/>
<div class="summary">
          <table class="summary">
            <tr><th colspan="2" class="title"><xsl:value-of select="summary_table_hdr/@results_summary_hdr"/></th></tr>
            <tr><th><xsl:value-of select="summary_table_hdr/@checks_run_hdr"/></th><td style="width: 30%"><xsl:value-of select="@totalCount"/></td></tr>
            <tr style="background-color:#FFFFCC"><th><xsl:value-of select="summary_table_hdr/@checks_pass_hdr"/></th><td style="width: 30%"><xsl:value-of select="@successCount"/></td></tr>
            <tr><th><xsl:value-of select="summary_table_hdr/@checks_error_hdr"/></th><td style="width: 30%"><xsl:value-of select="@errorCount"/></td></tr>
            <tr style="background-color:#FFFFCC"><th><xsl:value-of select="summary_table_hdr/@checks_incomp_hdr"/></th><td style="width: 30%"><xsl:value-of select="@failureCount"/></td></tr>
            <tr><th><xsl:value-of select="summary_table_hdr/@checks_notrun_hdr"/></th><td style="width: 30%"><xsl:value-of select="@notRunCount"/></td></tr>
            <tr style="background-color:#FFFFCC"><th><xsl:value-of select="summary_table_hdr/@checks_warning_hdr"/></th><td style="width: 30%"><xsl:value-of select="@warningCount"/></td></tr>
          </table>
<br/>
<br/>
          </div>
          <table class="results">
             <tr><th colspan="4" class="title"><xsl:value-of select="details_table_hdr/@hc_details_hdr" /></th></tr>
	     <tr>
             <th style="background-color:#FFFFCC" scope="col"><xsl:value-of select="details_table_hdr/@hc_name_hdr" /></th>
             <th style="background-color:#FFFFCC" scope="col"><xsl:value-of select="details_table_hdr/@hc_desc_hdr" /></th>
             <th style="background-color:#FFFFCC" scope="col"><xsl:value-of select="details_table_hdr/@hc_state_hdr" /></th>
             <th style="background-color:#FFFFCC" scope="col"><xsl:value-of select="details_table_hdr/@hc_rec_actions_hdr" /></th>
	     </tr>
            <xsl:apply-templates select="healthcheck"/>
          </table>
        
      </div>
   </body>
</html>
  </xsl:template>
<!--
  <xsl:template mode="header" match="healthcheck"><a href="#row_{@name}" class="headerLink"><xsl:value-of select="@checkname"/></a><xsl:value-of select="@checkname"/></xsl:template>
  <xsl:template mode="header" match="healthcheck"><xsl:value-of select="healthcheck[@checkname]"/></xsl:template>
-->

  <xsl:template match="healthcheck">
<!--       <table class="inner"> -->
	<tr>
         <td scope="row"><span style="font-style: italic;"><xsl:value-of select="@checkName" /></span></td>
         <td scope="row"><xsl:value-of select="@description" /></td>
         <td scope="row"><span style="font-style: italic;"><xsl:value-of select="@stateDescription" /></span></td>
         <td scope="row"><xsl:value-of select="recommendedActions/text()"/></td>
	</tr>
	<!--</table>-->
  </xsl:template>
</xsl:stylesheet>
