 
  <xsl:template name="processAnyAttribute">
    <xsl:param name="anyAttrs"  />
    <xsl:param name="delimiter"/>  
    <xsl:choose>
      <xsl:when test="normalize-space($anyAttrs) = ''" />     
      <xsl:otherwise>
        <xsl:call-template name="makeAttribute">
          <xsl:with-param name="anyAttrs" select="normalize-space($anyAttrs)" />
          <xsl:with-param name="delimiter" select="$delimiter" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="makeAttribute">
    <xsl:param name="anyAttrs" />
    <xsl:param name="delimiter" />  
    <xsl:choose>
      <xsl:when test="$delimiter = ''">
        <xsl:choose>     
           <xsl:when test="contains($anyAttrs, '{')">
             <xsl:variable name="attrName" select="substring-before($anyAttrs,'{')" />
             <xsl:variable name="namespace" select="substring-after(substring-before($anyAttrs,'}'),'{')" />             
             <xsl:variable name="value" select="substring-after($anyAttrs,'=')" />             
             <xsl:attribute name="{$attrName}" namespace="{$namespace}">        
               <xsl:value-of select="$value"/>   
             </xsl:attribute>   
           </xsl:when>  
           <xsl:otherwise>
             <xsl:variable name="attrName" select="substring-before($anyAttrs,'=')" />             
             <xsl:variable name="value" select="substring-after($anyAttrs,'=')" />
             <xsl:attribute name="{$attrName}">        
               <xsl:value-of select="$value"/>   
             </xsl:attribute>   
           </xsl:otherwise>
        </xsl:choose>       
     </xsl:when>
      <xsl:when test="contains($anyAttrs, $delimiter)">
        <xsl:if test="not(starts-with($anyAttrs, $delimiter))">        
          <xsl:call-template name="makeAttribute">
            <xsl:with-param name="anyAttrs" select="substring-before($anyAttrs, $delimiter)" />                   
          </xsl:call-template>
        </xsl:if>  
        <xsl:call-template name="makeAttribute">
          <xsl:with-param name="anyAttrs" select="substring-after($anyAttrs, $delimiter)" />
          <xsl:with-param name="delimiter" select="$delimiter" />
        </xsl:call-template>      
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="makeAttribute">
          <xsl:with-param name="anyAttrs" select="$anyAttrs" />        
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template> 

 
  <xsl:template name="processAny">
    <xsl:value-of select="concat('&lt;',local-name())"/>
    <xsl:if test="namespace-uri() != ''">
      <xsl:value-of select="concat(' xmlns=&quot;',namespace-uri(),'&quot;')"/>
    </xsl:if> 	
    <xsl:for-each select="./@*">
      <xsl:choose>
        <xsl:when test="namespace-uri() != ''">   
          <xsl:if test="namespace-uri() != 'http://www.w3.org/2000/xmlns/'">
            <xsl:value-of select="concat(' xmlns:ns',position(),'=&quot;',namespace-uri(),'&quot;')"/>
            <xsl:value-of select="concat(' ns',position(),':',local-name(),'=&quot;',.,'&quot;')"/>      
          </xsl:if>  
        </xsl:when> 	
        <xsl:otherwise>
          <xsl:value-of select="concat(' ',local-name(),'=&quot;',.,'&quot;')"/>      
        </xsl:otherwise>  
      </xsl:choose>
    </xsl:for-each>
    <xsl:value-of select="'&gt;'"/>
    <xsl:for-each select="./* | ./text()">
      <xsl:choose>
        <xsl:when test="local-name() = '#text'">
          <xsl:value-of select="."/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="processAny"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
    <xsl:value-of select="concat('&lt;/',local-name(),'&gt;')"/>
  </xsl:template>
