<?xml version="1.0" ?>
<!-- Schematron basic -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:oraxsl="http://www.w3.org/1999/XSL/TransformAlias"
                xmlns:sch="http://www.ascc.net/xml/schematron"
                exclude-result-prefixes="sch">
  <xsl:namespace-alias stylesheet-prefix="oraxsl" result-prefix="xsl"/>
  <xsl:template name="process-prolog">
    <oraxsl:output method="xml"/>
  </xsl:template>
  <xsl:template name="process-root">
    <xsl:param name="title"/>
    <xsl:param name="contents"/>
    <xsl:value-of select="$title"/>
    <xsl:text>&#10;</xsl:text>
    <xsl:copy-of select="$contents"/>
  </xsl:template>
  <xsl:template name="process-pattern">
    <xsl:param name="name"/>
    <xsl:text>&#10;</xsl:text>
    <xsl:text>&#10;</xsl:text>
    <xsl:text>From pattern "</xsl:text>
    <xsl:value-of select="$name"/>
    <xsl:text>": </xsl:text>
  </xsl:template>
  <xsl:template name="process-assert">
    <xsl:param name="test"/>
    <xsl:param name="role"/>
    <xsl:param name="diagnostics"/>
    <xsl:call-template name="process-message">
      <xsl:with-param name="pattern" select="$test"/>
      <xsl:with-param name="role" select="$role"/>
    </xsl:call-template>
  </xsl:template>
  <!-- Category: top-level-element -->
  <xsl:output method="xml" omit-xml-declaration="no" standalone="yes"
              indent="yes"/>
  <xsl:param name="block">
  </xsl:param>
  <!-- reserved -->
  <xsl:param name="phase">
    <xsl:choose>
      <xsl:when test="//sch:schema/@defaultPhase">
        <xsl:value-of select="//sch:schema/@defaultPhase"/>
      </xsl:when>
      <xsl:otherwise>#ALL</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <!-- workaround for Xalan4J 2.0 -->
  <xsl:param name="hiddenKey"> key </xsl:param>
  <!-- SCHEMA -->
  <xsl:template match="sch:schema | schema">
    <oraxsl:stylesheet version="2.0">
      <xsl:for-each select="sch:ns | ns">
        <xsl:attribute name="{concat(@prefix,':dummy-for-xmlns')}"
                       namespace="{@uri}"/>
      </xsl:for-each>
      <xsl:if test="count(sch:title/* | title/* )">
        <xsl:message>
          <xsl:text>Warning: </xsl:text>
          <xsl:value-of select="name(.)"/>
          <xsl:text> must not contain any child elements</xsl:text>
        </xsl:message>
      </xsl:if>
      <xsl:if test="not($phase = '#ALL')">
        <xsl:if test="not(sch:phase[@id = $phase] | phase[@id = $phase])">
          <xsl:message>Phase Error: no phase with name 
            <xsl:value-of select="$phase"/>
 has been defined.</xsl:message>
        </xsl:if>
      </xsl:if>
      <xsl:call-template name="process-prolog"/>
      <oraxsl:template match="/">
       <ns1:ValidationErrors xmlns:ns1="http://xmlns.oracle.com/pcbpel/validationservice">
      <xsl:apply-templates select="sch:pattern/sch:rule/sch:key | pattern/rule/key ">      
      </xsl:apply-templates>
      <xsl:apply-templates/>
      </ns1:ValidationErrors>
      </oraxsl:template>
      <oraxsl:template match="text()" priority="-1">
        <!-- strip characters -->
      </oraxsl:template>
    </oraxsl:stylesheet>
  </xsl:template>
  <!-- ASSERT and REPORT -->
  <xsl:template match="sch:assert | assert">
    <oraxsl:choose>
      <oraxsl:when test="{@test}">
      </oraxsl:when>
      <oraxsl:otherwise>    
        <error>
        <xsl:call-template name="process-assert">
          <xsl:with-param name="role" select="@role"/>
          <xsl:with-param name="id" select="@id"/>
          <xsl:with-param name="test" select="normalize-space(@test)"/>
          <xsl:with-param name="icon" select="@icon"/>
          <xsl:with-param name="subject" select="@subject"/>
          <xsl:with-param name="diagnostics" select="@diagnostics"/>
        </xsl:call-template>
        </error>        
      </oraxsl:otherwise>
    </oraxsl:choose>
  </xsl:template>
   <!-- swallow -->
  <!-- NAME -->
  <xsl:template match="sch:name | name">
    <oraxsl:text xml:space="preserve">
    </oraxsl:text>
    <xsl:if test="@path">
      <xsl:call-template name="process-name">
        <xsl:with-param name="name" select="concat('name(',@path,')')"/>
        <!-- SAXON needs that instead of  select="'name({@path})'"  -->
      </xsl:call-template>
    </xsl:if>
    <xsl:if test="not(@path)">
      <xsl:call-template name="process-name">
        <xsl:with-param name="name" select="'name(.)'"/>
      </xsl:call-template>
    </xsl:if>
    <oraxsl:text xml:space="preserve">
    </oraxsl:text>
  </xsl:template>
  <!-- NS -->
  <xsl:template match="sch:ns | ns">
    <xsl:if test="not(@uri)">
      <xsl:message>Markup Error: no uri attribute in &lt;ns></xsl:message>
    </xsl:if>
    <xsl:if test="not(@prefix)">
      <xsl:message>Markup Error: no prefix attribute in &lt;ns></xsl:message>
    </xsl:if>
    <xsl:call-template name="process-ns">
      <xsl:with-param name="prefix" select="@prefix"/>
      <xsl:with-param name="uri" select="@uri"/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="sch:ns | ns"/>
  <!-- swallow -->
  <!-- P -->
  <xsl:template match="sch:schema/sch:p | schema/p">
    <xsl:call-template name="process-p">
      <xsl:with-param name="class" select="@class"/>
      <xsl:with-param name="icon" select="@icon"/>
      <xsl:with-param name="id" select="@id"/>
      <xsl:with-param name="lang" select="@xml:lang"/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="sch:pattern/sch:p | pattern/p">
    <xsl:call-template name="process-p">
      <xsl:with-param name="class" select="@class"/>
      <xsl:with-param name="icon" select="@icon"/>
      <xsl:with-param name="id" select="@id"/>
      <xsl:with-param name="lang" select="@xml:lang"/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="sch:phase/sch:p"/>
  <!-- We don't use these -->
  <xsl:template match="sch:p | p"/>
  <!-- PATTERN -->
  <xsl:template match="sch:pattern | pattern">
    <xsl:if test="($phase = '#ALL')
or (../sch:phase[@id= ($phase)]/sch:active[@pattern= current()/@id])
or (../phase[@id= ($phase)]/active[@id= current()/@id])">
      <xsl:call-template name="process-pattern">
        <xsl:with-param name="name" select="@name"/>
        <xsl:with-param name="id" select="@id"/>
        <xsl:with-param name="see" select="@see"/>
        <xsl:with-param name="fpi" select="@fpi"/>
        <xsl:with-param name="icon" select="@icon"/>
      </xsl:call-template>
      <oraxsl:apply-templates select="/"/>
    </xsl:if>
  </xsl:template>
  <xsl:template match="sch:pattern | pattern">
      <xsl:apply-templates/>
  </xsl:template>
  
  <!-- RULE -->
  <xsl:template match="sch:rule[not(@abstract='true')] | rule[not(@abstract='true')]">
      <oraxsl:for-each select="{@context}">
       <xsl:call-template name="process-rule">
        <xsl:with-param name="id" select="@id"/>
        <xsl:with-param name="context" select="@context"/>
        <xsl:with-param name="role" select="@role"/>
      </xsl:call-template>
      <xsl:apply-templates/>
      <oraxsl:apply-templates/>
      </oraxsl:for-each>
  </xsl:template>
  <!-- ABSTRACT RULE -->
  <xsl:template match="sch:rule[@abstract='true'] | rule[@abstract='true']">
    <xsl:if test=" not(@id)">
      <xsl:message>
         Markup Error: no id attribute on abstract &lt;rule>
      </xsl:message>
    </xsl:if>
    <xsl:if test="@context">
      <xsl:message>
          Markup Error: (2) context attribute on abstract &lt;rule>
      </xsl:message>
    </xsl:if>
  </xsl:template>
  <xsl:template match="sch:rule[@abstract='true'] | rule[@abstract='true']"
                mode="extends">
    <xsl:if test="@context">
      <xsl:message>
          Markup Error: context attribute on abstract &lt;rule>
      </xsl:message>
    </xsl:if>
    <xsl:apply-templates/>
  </xsl:template>
  <!-- VALUE-OF -->
  <xsl:template match="sch:value-of | value-of" mode="text">
    <xsl:if test="not(@select)">
      <xsl:message>
          Markup Error: no select attribute in &lt;value-of>
      </xsl:message>
    </xsl:if>
    <oraxsl:text xml:space="preserve">
    </oraxsl:text>
    <xsl:choose>
      <xsl:when test="@select">
        <xsl:call-template name="process-value-of">
          <xsl:with-param name="select" select="@select"/>
          <!-- will saxon have problem with this too?? -->
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="process-value-of">
          <xsl:with-param name="select" select="'.'"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
    <oraxsl:text xml:space="preserve">
    </oraxsl:text>
  </xsl:template>
  <!-- ============================================================== -->
  <!-- Text -->
  <xsl:template match="text()" priority="-1" mode="do-keys">
    <!-- strip characters -->
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="do-all-patterns">
    <!-- strip characters -->
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="do-schema-p">
    <!-- strip characters -->
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="do-pattern-p">
    <!-- strip characters -->
  </xsl:template>
  <xsl:template match="text()" priority="-1">
    <!-- strip characters -->
  </xsl:template>
  <xsl:template match="text()" mode="text">
    <xsl:value-of select="normalize-space(.)"/>
  </xsl:template>
  
  <!-- ============================================================== -->
  <xsl:template match="*">
    <xsl:message>
      <xsl:text>Warning: unrecognized element </xsl:text>
      <xsl:value-of select="name(.)"/>
    </xsl:message>
  </xsl:template>
  <xsl:template match="*" mode="text">
    <xsl:message>
      <xsl:text>Warning: unrecognized element </xsl:text>
      <xsl:value-of select="name(.)"/>
    </xsl:message>
  </xsl:template>
  <!-- ============================================================== -->
  <!-- Default named templates -->
  <!-- These are the actions that are performed unless overridden -->
  <!-- no params -->
  <xsl:template name="process-diagnostic">
    <!-- params: id -->
    <xsl:apply-templates mode="text"/>
  </xsl:template>
  <xsl:template name="process-dir">
    <xsl:apply-templates mode="inline-text"/>
  </xsl:template>
  <xsl:template name="process-emph">
    <xsl:apply-templates mode="inline-text"/>
  </xsl:template>
  <xsl:template name="process-name">
    <xsl:param name="name"/>
    <oraxsl:value-of select="{$name}"/>
  </xsl:template>
  <xsl:template name="process-ns"/>
  <!-- unused params: prefix, uri -->
  <!-- note that this is independent of the use of sch:ns by sch:schema -->
  <xsl:template name="process-p"/>
  <!-- unused params: name, id, see, fpi, icon -->
  <xsl:template name="process-rule"/>
  <!-- unused params: id, context, role -->
  <xsl:template name="process-span">
    <xsl:apply-templates mode="inline-test"/>
  </xsl:template>
  <xsl:template name="process-value-of">
    <xsl:param name="select"/>
    <oraxsl:value-of select="{$select}"/>
  </xsl:template>
  <!-- default output action: the simplest customization is to just override this -->
  <xsl:template name="process-message">
    <!-- params: pattern, role -->
    <xsl:apply-templates mode="text"/>
  </xsl:template>
</xsl:stylesheet>
