/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.mongodb;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.mongodb.MongodbPojo;
import com.definesys.mpaas.mongodb.SimpleSqlHandler;
import com.definesys.mpaas.mongodb.TypeHandler;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.definesys.mpaas.query.db.Clause;
import com.definesys.mpaas.query.db.DatabaseAdapter;
import com.definesys.mpaas.query.db.DefaultDatabaseAdapter;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.db.StorageDatasource;
import com.definesys.mpaas.query.lookup.LookupHandler;
import com.definesys.mpaas.query.model.QueryInfo;
import com.definesys.mpaas.query.model.RowData;
import com.definesys.mpaas.query.model.RowValue;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="NOSQL_ADAPTER")
public class MongodbAdapter
extends DefaultDatabaseAdapter {
    @Autowired(required=false)
    private MongoDatabase mongo;
    @Autowired(required=false)
    private SWordLogger logger;

    @Override
    public <T> List<T> executeQuery(QueryInfo queryInfo, String sql, List<Parameter> params, Class<T> result) {
        if ("count".equalsIgnoreCase(queryInfo.getTag())) {
            return this.count(queryInfo, result);
        }
        String col = queryInfo.getTable();
        TypeHandler handler = new TypeHandler(queryInfo);
        Bson bson = handler.convert2Bsons();
        this.logger.debug("bson===>%s", bson);
        MongoCollection cols = this.mongo.getCollection(col, result);
        MongoIterable mit = null;
        mit = queryInfo.getDistinct() == null ? this.find(cols, queryInfo, bson, result) : this.distinct(cols, queryInfo, bson, result);
        MongoCursor docs = mit.iterator();
        List<Object> v = new ArrayList<Object>();
        while (docs.hasNext()) {
            v.add(docs.next());
        }
        if (Map.class == result) {
            v = this.clearObjectId(v);
        }
        if (result != null && !"java.lang.Long".equals(result.getName()) && !"lookup".equals(queryInfo.getTag())) {
            v = this.lookupHandle(queryInfo, v);
        }
        return v;
    }

    private <T> List<T> clearObjectId(List<T> data) {
        for (T t : data) {
            ObjectId id = (ObjectId)((Map)t).get("_id");
            ((Map)t).put("_id", id.toString());
        }
        return data;
    }

    private <T> MongoIterable find(MongoCollection cols, QueryInfo queryInfo, Bson bson, T result) {
        FindIterable fnd = null;
        fnd = bson != null ? cols.find(bson) : cols.find();
        Set<String> selectFields = queryInfo.getSelectFields();
        if (selectFields != null && selectFields.size() > 0) {
            fnd = fnd.projection(Projections.include((String[])selectFields.toArray(new String[0])));
        }
        Integer page = queryInfo.getPage();
        Integer pageSize = queryInfo.getPageSize();
        if (page != null) {
            fnd.skip((page - 1) * pageSize).limit(pageSize.intValue());
        }
        if (queryInfo.getOrderby() != null && queryInfo.getOrderby().size() > 0) {
            ArrayList<Bson> bs = new ArrayList<Bson>();
            for (Parameter p : queryInfo.getOrderby()) {
                if ("asc".equalsIgnoreCase((String)p.getValue())) {
                    bs.add(Sorts.ascending((String[])new String[]{p.getName()}));
                    continue;
                }
                bs.add(Sorts.descending((String[])new String[]{p.getName()}));
            }
            fnd.sort(Sorts.orderBy(bs));
        }
        return fnd;
    }

    private <T> MongoIterable distinct(MongoCollection cols, QueryInfo queryInfo, Bson bson, T result) {
        return cols.distinct(queryInfo.getDistinct(), String.class).filter(bson);
    }

    private <T> List<T> count(QueryInfo queryInfo, Class<T> result) {
        String col = queryInfo.getTable();
        TypeHandler handler = new TypeHandler(queryInfo);
        Bson bson = handler.convert2Bsons();
        MongoCollection cols = this.mongo.getCollection(col);
        ArrayList<Long> counts = new ArrayList<Long>();
        Long total = 0L;
        total = bson != null ? Long.valueOf(cols.countDocuments(bson)) : Long.valueOf(cols.countDocuments());
        counts.add(total);
        return counts;
    }

    @Override
    public List<Map<String, Object>> executeQueryAsList(QueryInfo queryInfo, String sql, List<Parameter> params) {
        if (queryInfo == null) {
            SimpleSqlHandler sqlHandler = new SimpleSqlHandler(sql, params);
            queryInfo = sqlHandler.buildQueryInfo();
        }
        List<Map> rs = this.executeQuery(queryInfo, null, null, Map.class);
        ArrayList<Map<String, Object>> mm = new ArrayList<Map<String, Object>>();
        for (Map m : rs) {
            HashMap row = new HashMap();
            for (Object key : m.keySet()) {
                row.put((String)key, m.get(key));
            }
            mm.add(row);
        }
        return mm;
    }

    @Override
    public int executeDelete(QueryInfo queryInfo, String sql, List<Parameter> params) {
        String col = queryInfo.getTable();
        String rowId = queryInfo.getRowId();
        DeleteResult rs = null;
        if (rowId != null) {
            rs = this.mongo.getCollection(col).deleteOne(Filters.eq((String)"_id", (Object)new ObjectId(rowId)));
        } else {
            TypeHandler handler = new TypeHandler(queryInfo);
            Bson bson = handler.convert2Bsons();
            if (bson == null) {
                throw MpaasRuntimeException.fromCode("SW-180229", new Object[0]);
            }
            rs = this.mongo.getCollection(col).deleteMany(bson);
        }
        return Long.valueOf(rs.getDeletedCount()).intValue();
    }

    @Override
    public int executeUpdate(QueryInfo queryInfo, String sql, List<Parameter> params) {
        String col = queryInfo.getTable();
        String rowId = queryInfo.getRowId();
        Object pojo = queryInfo.getPojo();
        UpdateResult rs = null;
        if (rowId != null) {
            if (pojo instanceof RowData) {
                rs = this.mongo.getCollection(col, queryInfo.getPojoClazz()).updateOne(Filters.eq((String)"_id", (Object)new ObjectId(rowId)), (Bson)new Document("$set", (Object)this.getRowData((RowData)pojo)));
            } else {
                List<Clause> updateFields = queryInfo.getUpdateField();
                if (updateFields != null && updateFields.size() > 0 && !queryInfo.isFullUpdate()) {
                    HashMap<String, Object> p = new HashMap<String, Object>();
                    for (Clause c : updateFields) {
                        p.put(c.getField(), c.getValue());
                    }
                    queryInfo.setPojo(p);
                    queryInfo.setPojoClazz(Map.class);
                }
                rs = queryInfo.getPojoClazz() != null ? this.mongo.getCollection(col, queryInfo.getPojoClazz()).updateOne(Filters.eq((String)"_id", (Object)new ObjectId(rowId)), (Bson)new Document("$set", queryInfo.getPojo())) : this.mongo.getCollection(col).updateOne(Filters.eq((String)"_id", (Object)new ObjectId(rowId)), (Bson)new Document("$set", queryInfo.getPojo()));
            }
        } else {
            TypeHandler handler = new TypeHandler(queryInfo);
            Bson bson = handler.convert2Bsons();
            if (bson == null) {
                throw MpaasRuntimeException.fromCode("SW-180229", new Object[0]);
            }
            if (pojo instanceof RowData) {
                rs = this.mongo.getCollection(col, queryInfo.getPojoClazz()).updateMany(bson, (Bson)new Document("$set", (Object)this.getRowData((RowData)pojo)));
            } else {
                List<Clause> updateFields = queryInfo.getUpdateField();
                if (updateFields != null && updateFields.size() > 0) {
                    HashMap<String, Object> p = new HashMap<String, Object>();
                    for (Clause c : updateFields) {
                        p.put(c.getField(), c.getValue());
                    }
                    queryInfo.setPojo(p);
                }
                rs = queryInfo.getPojoClazz() != null ? this.mongo.getCollection(col, queryInfo.getPojoClazz()).updateMany(bson, (Bson)new Document("$set", queryInfo.getPojo())) : this.mongo.getCollection(col).updateMany(bson, (Bson)new Document("$set", queryInfo.getPojo()));
            }
        }
        return Long.valueOf(rs.getModifiedCount()).intValue();
    }

    @Override
    public Object executeInsert(QueryInfo queryInfo, String sql, List<Parameter> params, String ... keyColumns) {
        String col = queryInfo.getTable();
        Object pojo = queryInfo.getPojo();
        if (pojo instanceof RowData) {
            this.mongo.getCollection(col, Map.class).insertOne((Object)this.getRowData((RowData)pojo));
        } else {
            this.mongo.getCollection(col, queryInfo.getPojoClazz()).insertOne(pojo);
        }
        if (pojo instanceof MongodbPojo) {
            return ((MongodbPojo)pojo).getId();
        }
        return null;
    }

    @Override
    public void dataSource(StorageDatasource dataSource) {
        this.mongo = (MongoDatabase)dataSource.getDatasource();
    }

    public DatabaseAdapter logger(SWordLogger logger) {
        this.logger = logger;
        return this;
    }

    private Map getRowData(RowData data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, RowValue> rv = data.getRow();
        for (String key : rv.keySet()) {
            result.put(key, rv.get(key).getValue());
        }
        return result;
    }

    @Override
    public Boolean isSqlDatabase() {
        return false;
    }

    public MongodbAdapter config(MpaasQueryConfig config) {
        this.config = config;
        return this;
    }

    @Override
    public DatabaseAdapter createInstance(MpaasQueryConfig config, SWordLogger logger) {
        return new MongodbAdapter().config(config).logger(logger);
    }

    private <T> List<T> lookupHandle(QueryInfo info, List<T> data) {
        LookupHandler<T> handler = new LookupHandler<T>(info.getPojoMeta(), data, info.getDbAdapter());
        handler.execute();
        return data;
    }
}

