/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.mongodb;

import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.query.conf.MpaasQueryConfig;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MongodbConfiguration {
    @Autowired
    private MpaasQueryConfig config;
    @Autowired
    private SWordLogger logger;

    @Bean
    public MongoDatabase mongodbConfig() {
        MongoDatabase database = null;
        try {
            CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()})});
            MongoClientSettings.Builder builder = MongoClientSettings.builder().codecRegistry(codecRegistry).applyConnectionString(new ConnectionString(this.config.dbUrl));
            if (this.config.dbUsername != null && this.config.dbUsername.trim().length() > 0) {
                MongoCredential credential = MongoCredential.createCredential((String)this.config.dbUsername, (String)this.config.dbDatabase, (char[])this.config.getPassword().toCharArray());
                builder.credential(credential);
            }
            MongoClientSettings settings = builder.build();
            MongoClient client = MongoClients.create((MongoClientSettings)settings);
            database = client.getDatabase(this.config.dbDatabase);
        }
        catch (Throwable ex) {
            this.logger.debug("mongodb configuration exception:" + ex.getMessage(), new Object[0]);
        }
        return database;
    }
}

