/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.mongodb;

import com.definesys.mpaas.common.exception.MpaasBusinessException;
import com.definesys.mpaas.query.db.Clause;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.model.QueryInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleSqlHandler {
    public static final String SIMPLE_SQL_REGEX = "select\\s+(.*?)from\\s+([^\\s]+).*?where\\s+(.*)";
    public static final String SIMPLE_SELECT_REGEX = "\\s*(\\w+)(\\s+\\w+)*\\s*,?\\s*";
    public static final String SIMPLE_WHERE_CLAUSE_REGEX = "(\\w+)\\s*(.*?)\\s*([\\w|'|:|\"]+)";
    public static final String STRING_S1 = "\\s*'([^']+)'\\s*";
    public static final String STRING_S2 = "\\s*\"([^\"]+)\"\\s*";
    public static final String STRING_S3 = "\\s*:(.*)\\s*";
    public static final Pattern SIMPLE_SQL_PATTERN = Pattern.compile("select\\s+(.*?)from\\s+([^\\s]+).*?where\\s+(.*)", 32);
    public static final Pattern SIMPLE_SELECT_PATTERN = Pattern.compile("\\s*(\\w+)(\\s+\\w+)*\\s*,?\\s*", 32);
    public static final Pattern SIMPLE_WHERE_CLAUSE_PATTERN = Pattern.compile("(\\w+)\\s*(.*?)\\s*([\\w|'|:|\"]+)", 32);
    public static final Pattern SIMPLE_STRING_S1 = Pattern.compile("\\s*'([^']+)'\\s*", 32);
    public static final Pattern SIMPLE_STRING_S2 = Pattern.compile("\\s*\"([^\"]+)\"\\s*", 32);
    public static final Pattern SIMPLE_STRING_S3 = Pattern.compile("\\s*:(.*)\\s*", 32);
    private String sql;
    private Map<String, Object> params;
    private List<Parameter> originParams;
    private QueryInfo queryInfo;

    public SimpleSqlHandler(String sql, List<Parameter> params) {
        this.sql = sql;
        this.originParams = params;
        if (params != null && !params.isEmpty()) {
            this.params = new HashMap<String, Object>();
            for (Parameter p : params) {
                this.params.put(p.getName(), p.getValue());
            }
        }
        this.queryInfo = new QueryInfo();
        this.queryInfo.setTag("lookup");
    }

    public QueryInfo buildQueryInfo() {
        if (this.sql == null) {
            throw new MpaasBusinessException("NO SQL SPECIALED");
        }
        return this.simpleSqlParser(this.sql);
    }

    private QueryInfo simpleSqlParser(String sql) {
        Matcher m1 = SIMPLE_SQL_PATTERN.matcher(sql);
        if (!m1.find()) {
            throw new MpaasBusinessException("SQL IS NOT CORRECT");
        }
        String select = m1.group(1);
        String document = m1.group(2);
        String where = m1.group(3);
        this.buildSelectField(select);
        this.buidlDocument(document);
        this.buildWhere(where);
        this.queryInfo.setParams(this.originParams);
        return this.queryInfo;
    }

    private void buildSelectField(String field) {
        Matcher m1 = SIMPLE_SELECT_PATTERN.matcher(field);
        HashSet<String> fields = new HashSet<String>();
        while (m1.find()) {
            fields.add(m1.group(1));
        }
        if (fields.isEmpty()) {
            throw new MpaasBusinessException("SQL Select Field Is Not Specialed");
        }
        this.queryInfo.setSelectFields(fields);
    }

    private void buidlDocument(String document) {
        this.queryInfo.setTable(document);
    }

    private void buildWhere(String where) {
        where = where.replaceAll("\\s+and\\s+", ",");
        where = where.replaceAll("\\s+or\\s+", ",");
        String[] clauses = where.split(",");
        ArrayList<Clause> result = new ArrayList<Clause>();
        for (String clause : clauses) {
            if (clause == null) continue;
            result.addAll(this.buildSingleClause(clause));
        }
        this.queryInfo.setClauses(result);
    }

    private List<Clause> buildSingleClause(String clause) {
        String clauseConjuction = "and";
        if (clause.matches("\\s+or\\s+")) {
            clauseConjuction = "or";
        }
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        Matcher m = SIMPLE_WHERE_CLAUSE_PATTERN.matcher(clause);
        while (m.find()) {
            String left = m.group(1);
            String op = m.group(2);
            String right = m.group(3);
            clauses.add(new Clause(left, op, clauseConjuction, this.parseValue(right)));
        }
        return clauses;
    }

    private Object parseValue(String s) {
        Matcher m1 = SIMPLE_STRING_S1.matcher(s);
        if (m1.find()) {
            return m1.group(1);
        }
        Matcher m2 = SIMPLE_STRING_S2.matcher(s);
        if (m2.find()) {
            return m2.group(1);
        }
        Matcher m3 = SIMPLE_STRING_S3.matcher(s);
        if (m3.find() && this.params != null) {
            return this.params.get(m3.group(1));
        }
        return s;
    }
}

