/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.mongodb;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.query.db.Clause;
import com.definesys.mpaas.query.db.ConjunctionPosition;
import com.definesys.mpaas.query.model.QueryInfo;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.List;
import org.bson.conversions.Bson;

public class TypeHandler {
    private List<Clause> clauseList;
    private QueryInfo queryInfo;

    public TypeHandler() {
    }

    public TypeHandler(QueryInfo queryInfo) {
        this.queryInfo = queryInfo;
        this.clauseList = queryInfo.getClauses();
        this.preHandle();
    }

    private void preHandle() {
        for (Clause c : this.clauseList) {
            c.setTag(false);
        }
        for (ConjunctionPosition p : this.queryInfo.getGroupConIndex()) {
            if (p.getArraryIndex() >= this.clauseList.size()) continue;
            this.clauseList.get(p.getArraryIndex()).setTag(true);
        }
    }

    public Bson clause2Bson(Clause clause) {
        String op = clause.getOp();
        String f = clause.getField();
        Object v = clause.getValue();
        Bson bs = null;
        if ("=".equals(op)) {
            bs = Filters.eq((String)f, (Object)v);
        } else if ("!=".equals(op)) {
            bs = Filters.ne((String)f, (Object)v);
        } else if ("like".equals(op)) {
            bs = Filters.regex((String)f, (String)((String)v), (String)"i");
        } else if (">".equals(op)) {
            bs = Filters.gt((String)f, (Object)v);
        } else if (">=".equals(op)) {
            bs = Filters.gte((String)f, (Object)v);
        } else if ("<".equals(op)) {
            bs = Filters.lt((String)f, (Object)v);
        } else if ("<=".equals(op)) {
            bs = Filters.lte((String)f, (Object)v);
        } else if ("in".equals(op)) {
            bs = Filters.in((String)f, clause.getValues());
        } else if ("not in".equals(op)) {
            bs = Filters.nin((String)f, clause.getValues());
        } else if ("^".equals(op)) {
            bs = Filters.regex((String)f, (String)("^" + v + ""), (String)"i");
        } else if ("$".equals(op)) {
            bs = Filters.regex((String)f, (String)(v + "$"), (String)"i");
        } else if ("is null".equals(op)) {
            bs = Filters.or((Bson[])new Bson[]{Filters.exists((String)f, (boolean)false), Filters.eq((String)f, (Object)"")});
        } else if ("is not null".equals(op)) {
            bs = Filters.exists((String)f);
        } else if ("not like".equals(op)) {
            bs = Filters.regex((String)f, (String)("^(?!.*" + v + ").*$"), (String)"i");
        } else if (!"between".equals(op)) {
            throw new MpaasRuntimeException("not support operation:" + op);
        }
        return bs;
    }

    private String calConjuction(int index) {
        List<ConjunctionPosition> groups = this.queryInfo.getGroupConIndex();
        for (int i = groups.size() - 1; i >= 0; --i) {
            ConjunctionPosition c = groups.get(i);
            if (c.getArraryIndex() > index) continue;
            return c.getConjunction();
        }
        return this.clauseList.get(index).getConjunction();
    }

    private Bson convert2Bsons(int from, int end) {
        if (this.clauseList == null || this.clauseList.size() == 0 || end > this.clauseList.size() || from >= end) {
            return null;
        }
        List<Clause> cls = null;
        cls = from == 0 && end == this.clauseList.size() ? this.clauseList : this.clauseList.subList(from, end);
        ArrayList<Bson> tmp = new ArrayList<Bson>();
        String pre = cls.get(0).getConjunction();
        tmp.add(this.clause2Bson(cls.get(0)));
        Bson bs = null;
        Bson bs1 = null;
        int index = 0;
        for (int i = 1; i < cls.size(); ++i) {
            Clause c = cls.get(i);
            if (c.getConjunction().equals(pre) && !((Boolean)c.getTag()).booleanValue()) {
                tmp.add(this.clause2Bson(c));
            } else {
                String s;
                Bson bson = tmp.size() == 1 ? (Bson)tmp.get(0) : (bs1 = "and".equals(pre) ? Filters.and(tmp) : Filters.or(tmp));
                bs = bs == null ? bs1 : ("and".equals(s = this.calConjuction(index)) ? Filters.and((Bson[])new Bson[]{bs, bs1}) : Filters.or((Bson[])new Bson[]{bs, bs1}));
                tmp = new ArrayList();
                tmp.add(this.clause2Bson(c));
                index = i;
            }
            pre = c.getConjunction();
        }
        if (!tmp.isEmpty()) {
            String s;
            Bson bson = tmp.size() == 1 ? (Bson)tmp.get(0) : (bs1 = "and".equals(pre) ? Filters.and(tmp) : Filters.or(tmp));
            bs = bs == null ? bs1 : ("and".equals(s = this.calConjuction(index)) ? Filters.and((Bson[])new Bson[]{bs, bs1}) : Filters.or((Bson[])new Bson[]{bs, bs1}));
        }
        return bs;
    }

    public Bson convert2Bsons() {
        List<ConjunctionPosition> groups = this.queryInfo.getGroupConIndex();
        int size = groups.size();
        int begin = 0;
        int end = 0;
        Bson bs = null;
        Bson bs1 = null;
        boolean bok = false;
        block0: for (int i = 0; i < size; ++i) {
            ConjunctionPosition g = groups.get(i);
            if (!g.isGroupBegin()) continue;
            for (int j = i + 1; j < size; ++j) {
                String s;
                i = j;
                ConjunctionPosition g1 = groups.get(j);
                if (!g1.isGroupEnd() && j != size - 1) continue;
                end = g1.isGroupEnd() ? g1.getArraryIndex() : this.clauseList.size();
                bs1 = this.convert2Bsons(begin, end);
                bs = bs == null ? bs1 : ("and".equals(s = this.calConjuction(begin)) ? Filters.and((Bson[])new Bson[]{bs, bs1}) : Filters.or((Bson[])new Bson[]{bs, bs1}));
                begin = g1.getArraryIndex();
                bok = j == size - 1;
                continue block0;
            }
        }
        if (!bok) {
            String s;
            bs1 = this.convert2Bsons(begin, this.clauseList.size());
            bs = bs == null ? bs1 : ("and".equals(s = this.calConjuction(begin)) ? Filters.and((Bson[])new Bson[]{bs, bs1}) : Filters.or((Bson[])new Bson[]{bs, bs1}));
        }
        return bs;
    }
}

