/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.mybatis;

import com.definesys.mpaas.common.exception.MpaasRuntimeException;
import com.definesys.mpaas.log.SWordLogger;
import com.definesys.mpaas.mybatis.QueryWrapper;
import com.definesys.mpaas.mybatis.mapper.SWordMybatisMapper;
import com.definesys.mpaas.pojo.PojoCache;
import com.definesys.mpaas.pojo.PojoField;
import com.definesys.mpaas.pojo.PojoMeta;
import com.definesys.mpaas.query.db.Clause;
import com.definesys.mpaas.query.db.DefaultDatabaseAdapter;
import com.definesys.mpaas.query.db.Parameter;
import com.definesys.mpaas.query.lookup.LookupHandler;
import com.definesys.mpaas.query.model.QueryInfo;
import com.definesys.mpaas.query.util.TypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MybatisDatabaseAdapter
extends DefaultDatabaseAdapter {
    @Autowired(required=false)
    private SWordMybatisMapper sWordMapper;
    @Autowired
    private SWordLogger logger;

    @Override
    public <T> List<T> executeQuery(QueryInfo queryInfo, String sql, List<Parameter> params, Class<T> result) {
        QueryWrapper wrapper = this.wrapper(sql, params);
        List<Map<String, Object>> rows = this.sWordMapper.query(wrapper);
        List<Object> _rows = new ArrayList();
        this.log("executeQuery", sql, params);
        try {
            PojoMeta meta = (PojoMeta)PojoCache.cache().get(result.getName(), result);
            for (Map<String, Object> row : rows) {
                Object r = null;
                if ("java.lang.Long".equals(result.getName())) {
                    for (String c : row.keySet()) {
                        r = Class.forName("java.lang.Long").getConstructor(Class.forName("java.lang.String")).newInstance(row.get(c).toString());
                    }
                } else {
                    r = Class.forName(result.getName()).newInstance();
                    for (String c : row.keySet()) {
                        PojoField field = meta.findPojoField(c);
                        if (field == null) continue;
                        field.setValue(r, TypeUtil.convert(row.get(c), field.getField().getType()));
                    }
                }
                _rows.add(r);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result != null && !"java.lang.Long".equals(result.getName())) {
            _rows = this.lookupHandle(queryInfo, _rows);
        }
        return _rows;
    }

    private <T> List<T> lookupHandle(QueryInfo info, List<T> data) {
        LookupHandler<T> handler = new LookupHandler<T>(info.getPojoMeta(), data, info.getDbAdapter());
        handler.execute();
        return data;
    }

    @Override
    public List<Map<String, Object>> executeQueryAsList(QueryInfo queryInfo, String sql, List<Parameter> params) {
        this.log("executeQueryAsList", sql, params);
        return this.sWordMapper.query(this.wrapper(sql, params));
    }

    @Override
    public int executeDelete(QueryInfo queryInfo, String sql, List<Parameter> params) {
        this.log("executeDelete", sql, params);
        this.evailValid(queryInfo, params);
        return this.sWordMapper.delete(this.wrapper(sql, params));
    }

    @Override
    public int executeUpdate(QueryInfo queryInfo, String sql, List<Parameter> params) {
        this.log("executeUpdate", sql, params);
        this.evailValid(queryInfo, params);
        return this.sWordMapper.update(this.wrapper(sql, params));
    }

    @Override
    public Object executeInsert(QueryInfo queryInfo, String sql, List<Parameter> params, String ... keyColumns) {
        this.log("executeInsert", sql, params);
        QueryWrapper wrapper = this.wrapper(sql, params);
        this.sWordMapper.insert(wrapper);
        return wrapper.getId();
    }

    private void evailValid(QueryInfo queryInfo, List<Parameter> params) {
        List<Clause> clauses;
        if (!(params != null && params.size() != 0 || (clauses = queryInfo.getClauses()) != null && clauses.size() != 0 && "in".equals(clauses.get(0).getOp()))) {
            throw MpaasRuntimeException.fromCode("SW-180229", new Object[0]);
        }
        boolean bok = true;
        for (Parameter p : params) {
            if (p.getValue() == null) continue;
            bok = false;
            break;
        }
        if (bok) {
            throw MpaasRuntimeException.fromCode("SW-180229", new Object[0]);
        }
    }

    private QueryWrapper wrapper(String sql, List<Parameter> params) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setSql(sql);
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (params != null) {
            for (Parameter p : params) {
                data.put(p.getName(), p.getValue());
            }
        }
        wrapper.setParams(data);
        return wrapper;
    }

    private void log(String action, String sql, List<Parameter> parameters) {
        this.logger.debug(action + " sql==>%s", sql);
        if (parameters != null) {
            this.logger.debug("params:", new Object[0]);
            for (Parameter p : parameters) {
                this.logger.debug("%s ==> %s", p.getName(), p.getValue());
            }
        }
    }

    @Override
    public Boolean isSqlDatabase() {
        return true;
    }

    @Override
    public String varformat() {
        return "#{params.%s}";
    }
}

