/*
 * Decompiled with CFR 0.152.
 */
package com.definesys.mpaas.pojo;

import com.definesys.mpaas.common.util.MpaasUtil;
import com.definesys.mpaas.query.annotation.Column;
import com.definesys.mpaas.query.annotation.ColumnType;
import com.definesys.mpaas.query.annotation.DataFrom;
import com.definesys.mpaas.query.annotation.Link;
import com.definesys.mpaas.query.annotation.Lookup;
import com.definesys.mpaas.query.annotation.RowID;
import com.definesys.mpaas.query.annotation.Style;
import com.definesys.mpaas.query.annotation.SystemColumn;
import com.definesys.mpaas.query.annotation.SystemColumnType;
import com.definesys.mpaas.query.annotation.Tag;
import com.definesys.mpaas.query.db.RowIDInfo;
import com.definesys.mpaas.query.model.RowData;
import com.definesys.mpaas.query.util.MpaasQueryUtil;
import com.definesys.mpaas.query.util.TypeUtil;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class PojoField {
    private Field field;
    private Boolean isRowId = false;
    private String sqlColumnName;
    private SystemColumnType systemColumnType;
    private Method getter;
    private Method setter;
    private String displayName;
    private ColumnType columnType = ColumnType.DB;
    private Style style;
    private JsonDeserialize deserialize;
    private Lookup lookup;
    private Link link;
    private RowIDInfo rowIDInfo;
    private Boolean isTenant = false;
    private DataFrom dataFrom;
    private Tag tag;
    private Boolean camelConvert;

    public PojoField(Field f, Method getter, Method setter, Boolean camelConvert) {
        this.field = f;
        this.getter = getter;
        this.setter = setter;
        this.camelConvert = camelConvert;
        this.init();
    }

    public PojoField(String name) {
        this.sqlColumnName = name;
    }

    private void init() {
        String s;
        RowID rowID = this.field.getAnnotation(RowID.class);
        if (rowID != null) {
            this.isRowId = true;
            this.rowIDInfo = new RowIDInfo(rowID);
        }
        if (this.field.getAnnotation(Column.class) != null && !MpaasUtil.strEmpty(s = this.field.getAnnotation(Column.class).value())) {
            this.sqlColumnName = s;
        }
        if (this.field.getAnnotation(SystemColumn.class) != null) {
            this.systemColumnType = this.field.getAnnotation(SystemColumn.class).value();
            if (this.systemColumnType == SystemColumnType.TENANT) {
                this.isTenant = true;
            }
        }
        this.displayName = this.field.getName();
        Column c = this.field.getAnnotation(Column.class);
        this.style = this.field.getAnnotation(Style.class);
        this.deserialize = this.field.getAnnotation(JsonDeserialize.class);
        if (this.sqlColumnName == null) {
            String string = this.sqlColumnName = this.camelConvert != false ? MpaasQueryUtil.camelConvert(this.field.getName()) : this.field.getName().toLowerCase();
        }
        if (c != null) {
            if (c.display() != null && c.display().trim().length() > 0) {
                this.displayName = c.display();
            }
            if (c.type() != null) {
                this.columnType = c.type();
            }
        }
        if (this.style != null && !MpaasUtil.strEmpty(this.style.displayName())) {
            this.displayName = this.style.displayName();
        }
        this.lookup = this.field.getAnnotation(Lookup.class);
        this.link = this.field.getAnnotation(Link.class);
        this.tag = this.field.getAnnotation(Tag.class);
        this.dataFrom = this.field.getAnnotation(DataFrom.class);
        if (this.dataFrom != null) {
            this.columnType = ColumnType.JAVA;
        }
    }

    public Object getTagValue() {
        Tag tag = this.field.getAnnotation(Tag.class);
        return tag == null ? null : tag.value();
    }

    public Object getValue(Object pojo) {
        if (pojo instanceof RowData) {
            return ((RowData)pojo).getValue(this.sqlColumnName);
        }
        if (this.getter != null) {
            try {
                Object value = this.getter.invoke(pojo, new Object[0]);
                return value;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Object getFormatValue(Object pojo) {
        if (pojo == null) {
            return null;
        }
        Object value = this.getValue(pojo);
        String format = "yyyy/MM/dd";
        Object result = value;
        if (value instanceof Date) {
            if (this.style != null && !MpaasUtil.strEmpty(this.style.format())) {
                format = this.style.format();
            } else if (this.deserialize != null && "MpaasDateTimeDeserializer".equals(this.deserialize.using().getSimpleName())) {
                format = "yyyy/MM/dd HH:mm:ss";
            }
            result = new SimpleDateFormat(format).format((Date)value);
        }
        return result;
    }

    public void setValue(Object pojo, Object value) {
        if (pojo instanceof RowData) {
            ((RowData)pojo).setValue(this.sqlColumnName, value);
            return;
        }
        if (this.setter != null) {
            try {
                this.setter.invoke(pojo, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public Boolean isKeyField() {
        return this.isRowId;
    }

    public String getSqlColumnName(Boolean upper2Uderline) {
        if (this.sqlColumnName != null) {
            return this.sqlColumnName;
        }
        return upper2Uderline != false ? MpaasQueryUtil.upper2Underline(this.field.getName()) : this.field.getName();
    }

    public void setSqlColumnName(String sqlColumnName) {
        this.sqlColumnName = sqlColumnName;
    }

    public SystemColumnType getSystemColumnType() {
        return this.systemColumnType;
    }

    public void setSystemColumnType(SystemColumnType systemColumnType) {
        this.systemColumnType = systemColumnType;
    }

    public Method getter() {
        return this.getter;
    }

    public Method setter() {
        return this.setter;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean isRowId() {
        return this.isRowId;
    }

    public Boolean isDBColumn() {
        return this.columnType == ColumnType.DB && this.link == null;
    }

    public Boolean isQueryColumn() {
        return this.columnType == ColumnType.DB || this.columnType == ColumnType.CALCULATE;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void setRowId(Boolean rowId) {
        this.isRowId = rowId;
    }

    public RowIDInfo getRowIDInfo() {
        return this.rowIDInfo;
    }

    public void setRowIDInfo(RowIDInfo rowIDInfo) {
        if (rowIDInfo != null) {
            this.isRowId = true;
        }
        this.rowIDInfo = rowIDInfo;
    }

    public String getFieldName() {
        if (this.field != null) {
            return this.field.getName();
        }
        return this.sqlColumnName;
    }

    public Link getLink() {
        return this.link;
    }

    public Boolean isTenant() {
        return this.isTenant;
    }

    public Boolean isStateField() {
        return this.systemColumnType == SystemColumnType.STATE;
    }

    public Tag getTag() {
        return this.tag;
    }

    public DataFrom getDataFrom() {
        return this.dataFrom;
    }

    public Boolean isBasicType() {
        return TypeUtil.isBasicType(this.field.getType());
    }

    public Boolean isListType() {
        return this.field != null && (this.field.getType() == List.class || this.field.getType().getSuperclass() == List.class);
    }

    public Boolean isObjectType() {
        return this.isBasicType() == false && this.isListType() == false;
    }

    public String getColumnName() {
        return this.sqlColumnName;
    }

    public boolean isCamel() {
        return this.camelConvert;
    }
}

